<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;
if ( get_option( 'wb_1117_license_status', false) != 'valid' ){
	add_action( 'admin_notices', 'wpbaran_1117_license_notice' );
}
function wpbaran_1117_license_notice() {
    ?>
    <div class="notice notice-error">
        <p>قالب آوادا وردپرس باران فعال شده است ولی تمام امکانات آن در دسترس نیست. برای استفاده از تمامی امکانات قالب، از منوهای پیشخوان وردپرس خود وارد بخش لایسنس‌ها > لایسنس آوادا شوید و لایسنس خود را فعال کنید.</p>
    </div>
    <?php
}
function wb_1117_license_menu() {
	if ( empty ( $GLOBALS['admin_page_hooks']['wb_PLUGIN_LICENSE_PAGE'] ) ) {
		add_menu_page(
		'لایسنس‌ها',
		'لایسنس‌ها',
		'manage_options',
		'wb_PLUGIN_LICENSE_PAGE',
		'wb_1117_parent_license_page',
		/*string $icon_url =*/ '',
		66
		);
	}
	add_submenu_page(
	'wb_PLUGIN_LICENSE_PAGE',
	'لایسنس قالب آوادا',
	'لایسنس آوادا',
	'manage_options',
	'wb_1117_PLUGIN_LICENSE_PAGE',
	'wb_1117_license_page',
	/*int $position =*/ null
	);
}
add_action('admin_menu', 'wb_1117_license_menu');
function wb_1117_parent_license_page() {
	?>
	<div class="wrap">
		<h1>لایسنس‌ها</h1>
		<p>برای فعال سازی لایسنس هر یک از محصولات می توانید از منوی لایسنس‌ها و زیرمنوی لایسنس محصول مورد نظر اقدام کنید.</p>
	</div>
	<?php
}

function wb_1117_license_page() {
	$license = get_option( 'wb_1117_license_key' );
	$status  = get_option( 'wb_1117_license_status' );
	?>
	<div class="wrap">
		<h1>لایسنس قالب آوادا</h1>
		<p>کلید لایسنس خود را وارد و ذخیره کنید. لایسنس را می توانید از حساب کاربری خود در سایت وردپرس باران، بخش لایسنس‌ها دریافت کنید: <a href='https://wpbaran.ir/profile/api-keys/' target='_blank'>دریافت لایسنس</a></p>
		<form method="post" action="options.php">
			<?php settings_fields('wb_1117_license'); ?>
			<table class="form-table">
				<tbody>
					<tr valign="top">
						<th scope="row" valign="top">کلید لایسنس</th>
						<td>
							<input id="wb_1117_license_key" name="wb_1117_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license ); ?>" />
						</td>
					</tr>
						<tr valign="top">
							<th scope="row" valign="top">وضعیت فعال‌سازی</th>
							<td>
								<?php if( $status !== false && $status == 'valid' ) { ?>
									<span style="color:green;">قالب شما فعال است.</span>
									<?php wp_nonce_field( 'wb_1117_nonce', 'wb_1117_nonce' ); ?>
								<?php } else { ?>
									<span style="color:red;">قالب شما فعال نیست. برای استفاده از همه امکانات قالب باید لایسنس خود را فعال کنید.</span>
									<?php wp_nonce_field( 'wb_1117_nonce', 'wb_1117_nonce' ); ?>
								<?php } ?>
							</td>
						</tr>
				</tbody>
			</table>
			<?php submit_button(); ?>
		</form>
	</div>
	<?php
}
function wb_1117_register_option() {
	register_setting('wb_1117_license', 'wb_1117_license_key', 'wb_1117_license' );
}
add_action('admin_init', 'wb_1117_register_option');
function wb_1117_license( $new ) {
	$old = get_option( 'wb_1117_license_key' );
	if( $old && $old != $new ) {
		delete_option( 'wb_1117_license_status' );
	}
	return $new;
}
function wb_1117_activate_license() {
	global $pagenow; 
	if ( ( get_option( 'wb_1117_license_key' ) ) && ( 'admin.php' === $pagenow ) && ( 'wb_1117_PLUGIN_LICENSE_PAGE' === $_GET['page'] ) ) {
		wb_1117_setnewstat();
	}
}
add_action('admin_init', 'wb_1117_activate_license');
function wb_1117_setnewstat() {
	$activated = 'inactive';
	//params
	//$wb_plugin_name = 'no-need';
	$wb_product_id = 1117;
	//$wb_slug = 'no-need';
	$wb_version = 0.0;
	$wb_license = trim( get_option( 'wb_1117_license_key' ) );
	$wb_home_url = home_url();
	$wb_instance = base64_encode( $wb_home_url . '#1117' );
	$wb_object = $wb_home_url;
	$api_params = array(
		'wc-api' => 'wc-am-api',
		'wc_am_action' => 'activate',
		//'plugin_name' => $wb_plugin_name,
		'product_id' => $wb_product_id,
		//'slug' => $wb_slug,
		'version' => $wb_version,
		'api_key' => $wb_license,
		'instance' => $wb_instance,
		'object' => $wb_object,
		
	);
	$response = wp_remote_post( 'https://wpbaran.ir/', array( 'timeout' => 30, 'sslverify' => false, 'body' => $api_params ) );
	if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {
		$message =  ( is_wp_error( $response ) && ! empty( $response->get_error_message() ) ) ? $response->get_error_message() : __( 'خطایی رخ داد! دوباره امتحان کنید.' );
	} else {
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		if ( false === $license_data->success ) {
			$message = $license_data->error;
		}
	}
	if ( ! empty( $message ) ) {	
		if ( 'Cannot activate API Key. The API Key has already been activated with the same unique instance ID sent with this request.' == $message ) {
			$activated = 'active';
		}
		else {
			return;
		}
	}
	if ( 'active' == $license_data->activated ) {
		$activated = 'active';
	}
	wb_1117_setstat( $activated );
}
function wb_1117_setstat( $stat ) {
	if ( 'active' == $stat ) {
		update_option( 'wb_1117_license_status', 'valid' );
	}
	else {
		update_option( 'wb_1117_license_status', 'invalid' );
	}
}
function wb_1117_getstat() {
	$stat = get_option( 'wb_1117_license_status' );
	return $stat;
}