<?php
/**
 * Extra files & functions are hooked here.
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package Avada
 * @subpackage Core
 * @since 1.0
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if ( ! defined( 'AVADA_VERSION' ) ) {
	define( 'AVADA_VERSION', '7.3.1' );
}

if ( ! defined( 'AVADA_MIN_PHP_VER_REQUIRED' ) ) {
	define( 'AVADA_MIN_PHP_VER_REQUIRED', '5.6' );
}

if ( ! defined( 'AVADA_MIN_WP_VER_REQUIRED' ) ) {
	define( 'AVADA_MIN_WP_VER_REQUIRED', '4.9' );
}

// Developer mode.
if ( ! defined( 'AVADA_DEV_MODE' ) ) {
	define( 'AVADA_DEV_MODE', false );
}
function wb_theme_updater() {
	require( get_template_directory() . '/wbupdater.php' );  
}
add_action( 'after_setup_theme', 'wb_theme_updater' );
/**
 * Compatibility check.
 *
 * Check that the site meets the minimum requirements for the theme before proceeding.
 *
 * @since 6.0
 */
if ( version_compare( $GLOBALS['wp_version'], AVADA_MIN_WP_VER_REQUIRED, '<' ) || version_compare( PHP_VERSION, AVADA_MIN_PHP_VER_REQUIRED, '<' ) ) {
	require_once get_template_directory() . '/includes/bootstrap-compat.php';
	return;
}

/**
 * Bootstrap the theme.
 *
 * @since 6.0
 */
require_once get_template_directory() . '/includes/bootstrap.php';

/* Omit closing PHP tag to avoid "Headers already sent" issues. */
function wpbaran_font() {
wp_enqueue_style( 'wpbaran-fonts', get_template_directory_uri().'/fonts/wpbaran-fonts/fonts.css' );
}

function wpbaran_fullavada(){
if(get_option('enable_full_version')!= 1){
update_option('enable_full_version', 1);
}
}

if ( get_option( 'wb_1117_license_status', false) == 'valid' ){
	add_action( 'wp_enqueue_scripts', 'wpbaran_font' );
	load_theme_textdomain( 'Avada', get_template_directory() . '/languages' );
	add_action('admin_init', 'wpbaran_fullavada');
}