/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-06-05 15:21:01 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12009 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=202 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=182 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_fusion_form_entries` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `field_id` bigint(20) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `privacy` tinyint(1) DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_fusion_form_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `field_name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_label` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_fusion_form_submissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `time` datetime NOT NULL,
  `source_url` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `privacy_scrub_date` date DEFAULT NULL,
  `on_privacy_scrub` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_fusion_forms` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `views` bigint(20) DEFAULT 0,
  `submissions_count` bigint(20) DEFAULT 0,
  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT 0,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT 0,
  `schedule_end` int(10) NOT NULL DEFAULT 0,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `flag_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `flag_popup` tinyint(1) NOT NULL DEFAULT 0,
  `group_id` int(10) DEFAULT NULL,
  `flag_group` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT 0,
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=28655 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=17849 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=11941 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hover` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `advanced` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11990 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hover` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `advanced` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `css` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `markup` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `css` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `markup` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` tinytext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` tinytext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("11942", "action_scheduler/migration_hook", "complete", "2021-06-05 15:05:00", "2021-06-05 19:35:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905500;}", "1", "1", "2021-06-05 15:18:49", "2021-06-05 19:48:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11943", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:31", "2021-06-05 19:34:31", "{\"update_callback\":\"wc_update_product_lookup_tables\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905471;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905471;}", "2", "1", "2021-06-05 15:07:43", "2021-06-05 19:37:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11944", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:32", "2021-06-05 19:34:32", "{\"update_callback\":\"wc_update_400_increase_size_of_column\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905472;}", "2", "1", "2021-06-05 15:07:57", "2021-06-05 19:37:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11945", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:33", "2021-06-05 19:34:33", "{\"update_callback\":\"wc_update_400_reset_action_scheduler_migration_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905473;}", "2", "1", "2021-06-05 15:08:03", "2021-06-05 19:38:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11946", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:34", "2021-06-05 19:34:34", "{\"update_callback\":\"wc_update_400_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905474;}", "2", "1", "2021-06-05 15:08:09", "2021-06-05 19:38:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11947", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:35", "2021-06-05 19:34:35", "{\"update_callback\":\"wc_update_440_insert_attribute_terms_for_variable_products\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905475;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905475;}", "2", "1", "2021-06-05 15:08:14", "2021-06-05 19:38:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11948", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:36", "2021-06-05 19:34:36", "{\"update_callback\":\"wc_update_440_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905476;}", "2", "1", "2021-06-05 15:08:20", "2021-06-05 19:38:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11949", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:37", "2021-06-05 19:34:37", "{\"update_callback\":\"wc_update_450_sanitize_coupons_code\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905477;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905477;}", "2", "1", "2021-06-05 15:08:32", "2021-06-05 19:38:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11950", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:38", "2021-06-05 19:34:38", "{\"update_callback\":\"wc_update_450_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905478;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905478;}", "2", "1", "2021-06-05 15:08:44", "2021-06-05 19:38:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11951", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:39", "2021-06-05 19:34:39", "{\"update_callback\":\"wc_update_500_fix_product_review_count\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905479;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905479;}", "2", "1", "2021-06-05 15:08:57", "2021-06-05 19:38:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11952", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:40", "2021-06-05 19:34:40", "{\"update_callback\":\"wc_update_500_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905480;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905480;}", "2", "1", "2021-06-05 15:09:10", "2021-06-05 19:39:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11953", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:36", "2021-06-05 19:34:36", "{\"update_callback\":\"wc_update_product_lookup_tables\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905476;}", "2", "1", "2021-06-05 15:08:25", "2021-06-05 19:38:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11954", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:37", "2021-06-05 19:34:37", "{\"update_callback\":\"wc_update_400_increase_size_of_column\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905477;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905477;}", "2", "1", "2021-06-05 15:08:38", "2021-06-05 19:38:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11955", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:38", "2021-06-05 19:34:38", "{\"update_callback\":\"wc_update_400_reset_action_scheduler_migration_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905478;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905478;}", "2", "1", "2021-06-05 15:08:50", "2021-06-05 19:38:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11956", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:39", "2021-06-05 19:34:39", "{\"update_callback\":\"wc_update_400_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905479;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905479;}", "2", "1", "2021-06-05 15:09:02", "2021-06-05 19:39:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11957", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:40", "2021-06-05 19:34:40", "{\"update_callback\":\"wc_update_440_insert_attribute_terms_for_variable_products\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905480;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905480;}", "2", "1", "2021-06-05 15:10:04", "2021-06-05 19:40:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11958", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:41", "2021-06-05 19:34:41", "{\"update_callback\":\"wc_update_440_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905481;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905481;}", "2", "1", "2021-06-05 15:10:16", "2021-06-05 19:40:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11959", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:42", "2021-06-05 19:34:42", "{\"update_callback\":\"wc_update_450_sanitize_coupons_code\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905482;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905482;}", "2", "1", "2021-06-05 15:10:30", "2021-06-05 19:40:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11960", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:43", "2021-06-05 19:34:43", "{\"update_callback\":\"wc_update_450_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905483;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905483;}", "2", "1", "2021-06-05 15:10:43", "2021-06-05 19:40:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11961", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:44", "2021-06-05 19:34:44", "{\"update_callback\":\"wc_update_500_fix_product_review_count\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905484;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905484;}", "2", "1", "2021-06-05 15:10:54", "2021-06-05 19:40:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11962", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:45", "2021-06-05 19:34:45", "{\"update_callback\":\"wc_update_500_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905485;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905485;}", "2", "1", "2021-06-05 15:11:07", "2021-06-05 19:41:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11963", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:40", "2021-06-05 19:34:40", "{\"update_callback\":\"wc_update_product_lookup_tables\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905480;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905480;}", "2", "1", "2021-06-05 15:10:10", "2021-06-05 19:40:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11964", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:41", "2021-06-05 19:34:41", "{\"update_callback\":\"wc_update_400_increase_size_of_column\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905481;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905481;}", "2", "1", "2021-06-05 15:10:23", "2021-06-05 19:40:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11965", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:42", "2021-06-05 19:34:42", "{\"update_callback\":\"wc_update_400_reset_action_scheduler_migration_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905482;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905482;}", "2", "1", "2021-06-05 15:10:37", "2021-06-05 19:40:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11966", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:43", "2021-06-05 19:34:43", "{\"update_callback\":\"wc_update_400_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905483;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905483;}", "2", "1", "2021-06-05 15:10:49", "2021-06-05 19:40:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11967", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:44", "2021-06-05 19:34:44", "{\"update_callback\":\"wc_update_440_insert_attribute_terms_for_variable_products\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905484;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905484;}", "2", "1", "2021-06-05 15:11:00", "2021-06-05 19:41:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11968", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:45", "2021-06-05 19:34:45", "{\"update_callback\":\"wc_update_440_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905485;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905485;}", "2", "1", "2021-06-05 15:11:13", "2021-06-05 19:41:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11969", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:46", "2021-06-05 19:34:46", "{\"update_callback\":\"wc_update_450_sanitize_coupons_code\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905486;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905486;}", "2", "1", "2021-06-05 15:11:19", "2021-06-05 19:41:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11970", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:47", "2021-06-05 19:34:47", "{\"update_callback\":\"wc_update_450_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905487;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905487;}", "2", "1", "2021-06-05 15:11:24", "2021-06-05 19:41:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11971", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:48", "2021-06-05 19:34:48", "{\"update_callback\":\"wc_update_500_fix_product_review_count\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905488;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905488;}", "2", "1", "2021-06-05 15:11:32", "2021-06-05 19:41:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11972", "woocommerce_run_update_callback", "complete", "2021-06-05 15:04:49", "2021-06-05 19:34:49", "{\"update_callback\":\"wc_update_500_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905489;}", "2", "1", "2021-06-05 15:11:41", "2021-06-05 19:41:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11973", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:43", "2021-06-05 19:37:43", "{\"column\":\"min_max_price\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905663;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905663;}", "3", "1", "2021-06-05 15:11:58", "2021-06-05 19:41:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11974", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:44", "2021-06-05 19:37:44", "{\"column\":\"stock_quantity\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905664;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905664;}", "3", "1", "2021-06-05 15:12:04", "2021-06-05 19:42:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11975", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:45", "2021-06-05 19:37:45", "{\"column\":\"sku\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905665;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905665;}", "3", "1", "2021-06-05 15:12:12", "2021-06-05 19:42:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11976", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:46", "2021-06-05 19:37:46", "{\"column\":\"stock_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905666;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905666;}", "3", "1", "2021-06-05 15:12:26", "2021-06-05 19:42:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11977", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:47", "2021-06-05 19:37:47", "{\"column\":\"average_rating\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905667;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905667;}", "3", "1", "2021-06-05 15:12:32", "2021-06-05 19:42:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11978", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:48", "2021-06-05 19:37:48", "{\"column\":\"total_sales\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905668;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905668;}", "3", "1", "2021-06-05 15:12:37", "2021-06-05 19:42:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11979", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:49", "2021-06-05 19:37:49", "{\"column\":\"downloadable\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905669;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905669;}", "3", "1", "2021-06-05 15:12:42", "2021-06-05 19:42:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11980", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:50", "2021-06-05 19:37:50", "{\"column\":\"virtual\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905670;}", "3", "1", "2021-06-05 15:12:49", "2021-06-05 19:42:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11981", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:51", "2021-06-05 19:37:51", "{\"column\":\"onsale\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905671;}", "3", "1", "2021-06-05 15:12:54", "2021-06-05 19:42:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11982", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:52", "2021-06-05 19:37:52", "{\"column\":\"tax_class\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905672;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905672;}", "3", "1", "2021-06-05 15:13:00", "2021-06-05 19:43:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11983", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:07:53", "2021-06-05 19:37:53", "{\"column\":\"tax_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905673;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905673;}", "3", "1", "2021-06-05 15:13:06", "2021-06-05 19:43:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11984", "wc_update_product_lookup_tables_rating_count_batch", "complete", "2021-06-05 15:07:53", "2021-06-05 19:37:53", "{\"offset\":0,\"limit\":50}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905673;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905673;}", "3", "1", "2021-06-05 15:13:13", "2021-06-05 19:43:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11985", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:25", "2021-06-05 19:38:25", "{\"column\":\"min_max_price\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905705;}", "3", "1", "2021-06-05 15:13:18", "2021-06-05 19:43:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11986", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:26", "2021-06-05 19:38:26", "{\"column\":\"stock_quantity\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905706;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905706;}", "3", "1", "2021-06-05 15:13:25", "2021-06-05 19:43:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11987", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:27", "2021-06-05 19:38:27", "{\"column\":\"sku\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905707;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905707;}", "3", "1", "2021-06-05 15:13:30", "2021-06-05 19:43:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11988", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:28", "2021-06-05 19:38:28", "{\"column\":\"stock_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905708;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905708;}", "3", "1", "2021-06-05 15:13:38", "2021-06-05 19:43:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11989", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:29", "2021-06-05 19:38:29", "{\"column\":\"average_rating\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905709;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905709;}", "3", "1", "2021-06-05 15:13:46", "2021-06-05 19:43:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11990", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:30", "2021-06-05 19:38:30", "{\"column\":\"total_sales\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905710;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905710;}", "3", "1", "2021-06-05 15:13:53", "2021-06-05 19:43:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11991", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:31", "2021-06-05 19:38:31", "{\"column\":\"downloadable\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905711;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905711;}", "3", "1", "2021-06-05 15:13:59", "2021-06-05 19:43:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11992", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:32", "2021-06-05 19:38:32", "{\"column\":\"virtual\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905712;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905712;}", "3", "1", "2021-06-05 15:14:04", "2021-06-05 19:44:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11993", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:33", "2021-06-05 19:38:33", "{\"column\":\"onsale\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905713;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905713;}", "3", "1", "2021-06-05 15:14:11", "2021-06-05 19:44:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11994", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:34", "2021-06-05 19:38:34", "{\"column\":\"tax_class\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905714;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905714;}", "3", "1", "2021-06-05 15:14:17", "2021-06-05 19:44:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11995", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:08:35", "2021-06-05 19:38:35", "{\"column\":\"tax_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905715;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905715;}", "3", "1", "2021-06-05 15:14:25", "2021-06-05 19:44:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11996", "wc_update_product_lookup_tables_rating_count_batch", "complete", "2021-06-05 15:08:35", "2021-06-05 19:38:35", "{\"offset\":0,\"limit\":50}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905715;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905715;}", "3", "1", "2021-06-05 15:14:31", "2021-06-05 19:44:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11997", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:10", "2021-06-05 19:40:10", "{\"column\":\"min_max_price\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905810;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905810;}", "3", "1", "2021-06-05 15:14:37", "2021-06-05 19:44:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11998", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:11", "2021-06-05 19:40:11", "{\"column\":\"stock_quantity\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905811;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905811;}", "3", "1", "2021-06-05 15:14:42", "2021-06-05 19:44:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("11999", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:12", "2021-06-05 19:40:12", "{\"column\":\"sku\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905812;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905812;}", "3", "1", "2021-06-05 15:14:49", "2021-06-05 19:44:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("12000", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:13", "2021-06-05 19:40:13", "{\"column\":\"stock_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905813;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905813;}", "3", "1", "2021-06-05 15:14:55", "2021-06-05 19:44:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("12001", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:14", "2021-06-05 19:40:14", "{\"column\":\"average_rating\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905814;}", "3", "1", "2021-06-05 15:15:02", "2021-06-05 19:45:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("12002", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:15", "2021-06-05 19:40:15", "{\"column\":\"total_sales\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905815;}", "3", "1", "2021-06-05 15:15:08", "2021-06-05 19:45:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("12003", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:16", "2021-06-05 19:40:16", "{\"column\":\"downloadable\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905816;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905816;}", "3", "1", "2021-06-05 15:15:15", "2021-06-05 19:45:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("12004", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:17", "2021-06-05 19:40:17", "{\"column\":\"virtual\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905817;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905817;}", "3", "1", "2021-06-05 15:15:21", "2021-06-05 19:45:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("12005", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:18", "2021-06-05 19:40:18", "{\"column\":\"onsale\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905818;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905818;}", "3", "1", "2021-06-05 15:15:29", "2021-06-05 19:45:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("12006", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:19", "2021-06-05 19:40:19", "{\"column\":\"tax_class\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905819;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905819;}", "3", "1", "2021-06-05 15:15:34", "2021-06-05 19:45:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("12007", "wc_update_product_lookup_tables_column", "complete", "2021-06-05 15:10:20", "2021-06-05 19:40:20", "{\"column\":\"tax_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905820;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905820;}", "3", "1", "2021-06-05 15:15:40", "2021-06-05 19:45:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("12008", "wc_update_product_lookup_tables_rating_count_batch", "complete", "2021-06-05 15:10:20", "2021-06-05 19:40:20", "{\"offset\":0,\"limit\":50}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1622905820;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1622905820;}", "3", "1", "2021-06-05 15:15:46", "2021-06-05 19:45:46", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1", "11942", "ایجاد فعالیت", "2021-06-05 15:04:00", "2021-06-05 19:34:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2", "11943", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3", "11944", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("4", "11945", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5", "11946", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("6", "11947", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7", "11948", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8", "11949", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("9", "11950", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("10", "11951", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("11", "11952", "ایجاد فعالیت", "2021-06-05 15:04:31", "2021-06-05 19:34:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("12", "11953", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("13", "11954", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("14", "11955", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("15", "11956", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("16", "11957", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("17", "11958", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("18", "11959", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("19", "11960", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("20", "11961", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("21", "11962", "ایجاد فعالیت", "2021-06-05 15:04:36", "2021-06-05 19:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("22", "11963", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("23", "11964", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("24", "11965", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("25", "11966", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("26", "11967", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("27", "11968", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("28", "11969", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("29", "11970", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("30", "11971", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("31", "11972", "ایجاد فعالیت", "2021-06-05 15:04:40", "2021-06-05 19:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("32", "11943", "action started via Admin List Table", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("33", "11973", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("34", "11974", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("35", "11975", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("36", "11976", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("37", "11977", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("38", "11978", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("39", "11979", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("40", "11980", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("41", "11981", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("42", "11982", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("43", "11983", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("44", "11984", "ایجاد فعالیت", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("45", "11943", "action complete via Admin List Table", "2021-06-05 15:07:43", "2021-06-05 19:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("46", "11944", "action started via Admin List Table", "2021-06-05 15:07:57", "2021-06-05 19:37:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("47", "11944", "action complete via Admin List Table", "2021-06-05 15:07:57", "2021-06-05 19:37:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("48", "11945", "action started via Admin List Table", "2021-06-05 15:08:03", "2021-06-05 19:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("49", "11945", "action complete via Admin List Table", "2021-06-05 15:08:03", "2021-06-05 19:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("50", "11946", "action started via Admin List Table", "2021-06-05 15:08:09", "2021-06-05 19:38:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("51", "11946", "action complete via Admin List Table", "2021-06-05 15:08:09", "2021-06-05 19:38:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("52", "11947", "action started via Admin List Table", "2021-06-05 15:08:14", "2021-06-05 19:38:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("53", "11947", "action complete via Admin List Table", "2021-06-05 15:08:14", "2021-06-05 19:38:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("54", "11948", "action started via Admin List Table", "2021-06-05 15:08:20", "2021-06-05 19:38:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("55", "11948", "action complete via Admin List Table", "2021-06-05 15:08:20", "2021-06-05 19:38:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("56", "11953", "action started via Admin List Table", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("57", "11985", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("58", "11986", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("59", "11987", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("60", "11988", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("61", "11989", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("62", "11990", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("63", "11991", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("64", "11992", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("65", "11993", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("66", "11994", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("67", "11995", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("68", "11996", "ایجاد فعالیت", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("69", "11953", "action complete via Admin List Table", "2021-06-05 15:08:25", "2021-06-05 19:38:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("70", "11949", "action started via Admin List Table", "2021-06-05 15:08:32", "2021-06-05 19:38:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("71", "11949", "action complete via Admin List Table", "2021-06-05 15:08:32", "2021-06-05 19:38:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("72", "11954", "action started via Admin List Table", "2021-06-05 15:08:38", "2021-06-05 19:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("73", "11954", "action complete via Admin List Table", "2021-06-05 15:08:38", "2021-06-05 19:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("74", "11950", "action started via Admin List Table", "2021-06-05 15:08:44", "2021-06-05 19:38:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("75", "11950", "action complete via Admin List Table", "2021-06-05 15:08:44", "2021-06-05 19:38:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("76", "11955", "action started via Admin List Table", "2021-06-05 15:08:50", "2021-06-05 19:38:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("77", "11955", "action complete via Admin List Table", "2021-06-05 15:08:50", "2021-06-05 19:38:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("78", "11951", "action started via Admin List Table", "2021-06-05 15:08:57", "2021-06-05 19:38:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("79", "11951", "action complete via Admin List Table", "2021-06-05 15:08:57", "2021-06-05 19:38:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("80", "11956", "action started via Admin List Table", "2021-06-05 15:09:02", "2021-06-05 19:39:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("81", "11956", "action complete via Admin List Table", "2021-06-05 15:09:02", "2021-06-05 19:39:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("82", "11952", "action started via Admin List Table", "2021-06-05 15:09:10", "2021-06-05 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("83", "11952", "action complete via Admin List Table", "2021-06-05 15:09:10", "2021-06-05 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("84", "11957", "action started via Admin List Table", "2021-06-05 15:10:04", "2021-06-05 19:40:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("85", "11957", "action complete via Admin List Table", "2021-06-05 15:10:04", "2021-06-05 19:40:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("86", "11963", "action started via Admin List Table", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("87", "11997", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("88", "11998", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("89", "11999", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("90", "12000", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("91", "12001", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("92", "12002", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("93", "12003", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("94", "12004", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("95", "12005", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("96", "12006", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("97", "12007", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("98", "12008", "ایجاد فعالیت", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("99", "11963", "action complete via Admin List Table", "2021-06-05 15:10:10", "2021-06-05 19:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("100", "11958", "action started via Admin List Table", "2021-06-05 15:10:16", "2021-06-05 19:40:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("101", "11958", "action complete via Admin List Table", "2021-06-05 15:10:16", "2021-06-05 19:40:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("102", "11964", "action started via Admin List Table", "2021-06-05 15:10:23", "2021-06-05 19:40:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("103", "11964", "action complete via Admin List Table", "2021-06-05 15:10:23", "2021-06-05 19:40:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("104", "11959", "action started via Admin List Table", "2021-06-05 15:10:30", "2021-06-05 19:40:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("105", "11959", "action complete via Admin List Table", "2021-06-05 15:10:30", "2021-06-05 19:40:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("106", "11965", "action started via Admin List Table", "2021-06-05 15:10:37", "2021-06-05 19:40:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("107", "11965", "action complete via Admin List Table", "2021-06-05 15:10:37", "2021-06-05 19:40:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("108", "11960", "action started via Admin List Table", "2021-06-05 15:10:43", "2021-06-05 19:40:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("109", "11960", "action complete via Admin List Table", "2021-06-05 15:10:43", "2021-06-05 19:40:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("110", "11966", "action started via Admin List Table", "2021-06-05 15:10:49", "2021-06-05 19:40:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("111", "11966", "action complete via Admin List Table", "2021-06-05 15:10:49", "2021-06-05 19:40:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("112", "11961", "action started via Admin List Table", "2021-06-05 15:10:54", "2021-06-05 19:40:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("113", "11961", "action complete via Admin List Table", "2021-06-05 15:10:54", "2021-06-05 19:40:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("114", "11967", "action started via Admin List Table", "2021-06-05 15:11:00", "2021-06-05 19:41:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("115", "11967", "action complete via Admin List Table", "2021-06-05 15:11:00", "2021-06-05 19:41:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("116", "11962", "action started via Admin List Table", "2021-06-05 15:11:07", "2021-06-05 19:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("117", "11962", "action complete via Admin List Table", "2021-06-05 15:11:07", "2021-06-05 19:41:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("118", "11968", "action started via Admin List Table", "2021-06-05 15:11:13", "2021-06-05 19:41:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("119", "11968", "action complete via Admin List Table", "2021-06-05 15:11:13", "2021-06-05 19:41:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("120", "11969", "action started via Admin List Table", "2021-06-05 15:11:19", "2021-06-05 19:41:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("121", "11969", "action complete via Admin List Table", "2021-06-05 15:11:19", "2021-06-05 19:41:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("122", "11970", "action started via Admin List Table", "2021-06-05 15:11:24", "2021-06-05 19:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("123", "11970", "action complete via Admin List Table", "2021-06-05 15:11:24", "2021-06-05 19:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("124", "11971", "action started via Admin List Table", "2021-06-05 15:11:32", "2021-06-05 19:41:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("125", "11971", "action complete via Admin List Table", "2021-06-05 15:11:32", "2021-06-05 19:41:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("126", "11972", "action started via Admin List Table", "2021-06-05 15:11:41", "2021-06-05 19:41:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("127", "11972", "action complete via Admin List Table", "2021-06-05 15:11:41", "2021-06-05 19:41:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("128", "11973", "action started via Admin List Table", "2021-06-05 15:11:58", "2021-06-05 19:41:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("129", "11973", "action complete via Admin List Table", "2021-06-05 15:11:58", "2021-06-05 19:41:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("130", "11974", "action started via Admin List Table", "2021-06-05 15:12:04", "2021-06-05 19:42:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("131", "11974", "action complete via Admin List Table", "2021-06-05 15:12:04", "2021-06-05 19:42:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("132", "11975", "action started via Admin List Table", "2021-06-05 15:12:12", "2021-06-05 19:42:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("133", "11975", "action complete via Admin List Table", "2021-06-05 15:12:12", "2021-06-05 19:42:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("134", "11976", "action started via Admin List Table", "2021-06-05 15:12:26", "2021-06-05 19:42:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("135", "11976", "action complete via Admin List Table", "2021-06-05 15:12:26", "2021-06-05 19:42:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("136", "11977", "action started via Admin List Table", "2021-06-05 15:12:32", "2021-06-05 19:42:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("137", "11977", "action complete via Admin List Table", "2021-06-05 15:12:32", "2021-06-05 19:42:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("138", "11978", "action started via Admin List Table", "2021-06-05 15:12:37", "2021-06-05 19:42:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("139", "11978", "action complete via Admin List Table", "2021-06-05 15:12:37", "2021-06-05 19:42:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("140", "11979", "action started via Admin List Table", "2021-06-05 15:12:42", "2021-06-05 19:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("141", "11979", "action complete via Admin List Table", "2021-06-05 15:12:42", "2021-06-05 19:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("142", "11980", "action started via Admin List Table", "2021-06-05 15:12:49", "2021-06-05 19:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("143", "11980", "action complete via Admin List Table", "2021-06-05 15:12:49", "2021-06-05 19:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("144", "11981", "action started via Admin List Table", "2021-06-05 15:12:54", "2021-06-05 19:42:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("145", "11981", "action complete via Admin List Table", "2021-06-05 15:12:54", "2021-06-05 19:42:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("146", "11982", "action started via Admin List Table", "2021-06-05 15:13:00", "2021-06-05 19:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("147", "11982", "action complete via Admin List Table", "2021-06-05 15:13:00", "2021-06-05 19:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("148", "11983", "action started via Admin List Table", "2021-06-05 15:13:06", "2021-06-05 19:43:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("149", "11983", "action complete via Admin List Table", "2021-06-05 15:13:06", "2021-06-05 19:43:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("150", "11984", "action started via Admin List Table", "2021-06-05 15:13:13", "2021-06-05 19:43:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("151", "11984", "action complete via Admin List Table", "2021-06-05 15:13:13", "2021-06-05 19:43:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("152", "11985", "action started via Admin List Table", "2021-06-05 15:13:18", "2021-06-05 19:43:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("153", "11985", "action complete via Admin List Table", "2021-06-05 15:13:18", "2021-06-05 19:43:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("154", "11986", "action started via Admin List Table", "2021-06-05 15:13:25", "2021-06-05 19:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("155", "11986", "action complete via Admin List Table", "2021-06-05 15:13:25", "2021-06-05 19:43:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("156", "11987", "action started via Admin List Table", "2021-06-05 15:13:30", "2021-06-05 19:43:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("157", "11987", "action complete via Admin List Table", "2021-06-05 15:13:30", "2021-06-05 19:43:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("158", "11988", "action started via Admin List Table", "2021-06-05 15:13:38", "2021-06-05 19:43:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("159", "11988", "action complete via Admin List Table", "2021-06-05 15:13:38", "2021-06-05 19:43:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("160", "11989", "action started via Admin List Table", "2021-06-05 15:13:46", "2021-06-05 19:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("161", "11989", "action complete via Admin List Table", "2021-06-05 15:13:46", "2021-06-05 19:43:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("162", "11990", "action started via Admin List Table", "2021-06-05 15:13:53", "2021-06-05 19:43:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("163", "11990", "action complete via Admin List Table", "2021-06-05 15:13:53", "2021-06-05 19:43:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("164", "11991", "action started via Admin List Table", "2021-06-05 15:13:59", "2021-06-05 19:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("165", "11991", "action complete via Admin List Table", "2021-06-05 15:13:59", "2021-06-05 19:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("166", "11992", "action started via Admin List Table", "2021-06-05 15:14:04", "2021-06-05 19:44:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("167", "11992", "action complete via Admin List Table", "2021-06-05 15:14:04", "2021-06-05 19:44:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("168", "11993", "action started via Admin List Table", "2021-06-05 15:14:11", "2021-06-05 19:44:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("169", "11993", "action complete via Admin List Table", "2021-06-05 15:14:11", "2021-06-05 19:44:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("170", "11994", "action started via Admin List Table", "2021-06-05 15:14:17", "2021-06-05 19:44:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("171", "11994", "action complete via Admin List Table", "2021-06-05 15:14:17", "2021-06-05 19:44:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("172", "11995", "action started via Admin List Table", "2021-06-05 15:14:25", "2021-06-05 19:44:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("173", "11995", "action complete via Admin List Table", "2021-06-05 15:14:25", "2021-06-05 19:44:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("174", "11996", "action started via Admin List Table", "2021-06-05 15:14:31", "2021-06-05 19:44:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("175", "11996", "action complete via Admin List Table", "2021-06-05 15:14:31", "2021-06-05 19:44:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("176", "11997", "action started via Admin List Table", "2021-06-05 15:14:37", "2021-06-05 19:44:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("177", "11997", "action complete via Admin List Table", "2021-06-05 15:14:37", "2021-06-05 19:44:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("178", "11998", "action started via Admin List Table", "2021-06-05 15:14:42", "2021-06-05 19:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("179", "11998", "action complete via Admin List Table", "2021-06-05 15:14:42", "2021-06-05 19:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("180", "11999", "action started via Admin List Table", "2021-06-05 15:14:49", "2021-06-05 19:44:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("181", "11999", "action complete via Admin List Table", "2021-06-05 15:14:49", "2021-06-05 19:44:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("182", "12000", "action started via Admin List Table", "2021-06-05 15:14:55", "2021-06-05 19:44:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("183", "12000", "action complete via Admin List Table", "2021-06-05 15:14:55", "2021-06-05 19:44:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("184", "12001", "action started via Admin List Table", "2021-06-05 15:15:02", "2021-06-05 19:45:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("185", "12001", "action complete via Admin List Table", "2021-06-05 15:15:02", "2021-06-05 19:45:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("186", "12002", "action started via Admin List Table", "2021-06-05 15:15:08", "2021-06-05 19:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("187", "12002", "action complete via Admin List Table", "2021-06-05 15:15:08", "2021-06-05 19:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("188", "12003", "action started via Admin List Table", "2021-06-05 15:15:15", "2021-06-05 19:45:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("189", "12003", "action complete via Admin List Table", "2021-06-05 15:15:15", "2021-06-05 19:45:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("190", "12004", "action started via Admin List Table", "2021-06-05 15:15:21", "2021-06-05 19:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("191", "12004", "action complete via Admin List Table", "2021-06-05 15:15:21", "2021-06-05 19:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("192", "12005", "action started via Admin List Table", "2021-06-05 15:15:29", "2021-06-05 19:45:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("193", "12005", "action complete via Admin List Table", "2021-06-05 15:15:29", "2021-06-05 19:45:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("194", "12006", "action started via Admin List Table", "2021-06-05 15:15:34", "2021-06-05 19:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("195", "12006", "action complete via Admin List Table", "2021-06-05 15:15:34", "2021-06-05 19:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("196", "12007", "action started via Admin List Table", "2021-06-05 15:15:40", "2021-06-05 19:45:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("197", "12007", "action complete via Admin List Table", "2021-06-05 15:15:40", "2021-06-05 19:45:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("198", "12008", "action started via Admin List Table", "2021-06-05 15:15:46", "2021-06-05 19:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("199", "12008", "action complete via Admin List Table", "2021-06-05 15:15:46", "2021-06-05 19:45:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("200", "11942", "action started via WP Cron", "2021-06-05 15:18:49", "2021-06-05 19:48:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("201", "11942", "action complete via WP Cron", "2021-06-05 15:18:49", "2021-06-05 19:48:49");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "یک نویسنده‌ی دیدگاه در وردپرس", "wapuu@wordpress.example", "https://wordpress.org/", "", "2019-04-21 19:03:12", "2019-04-21 15:33:12", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("3", "wpbaran_avada", "668ae9f3bffefd431513_20210605152022", "21", "2021-06-05 15:21:01", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-06-05 15:20:22\";s:7:\"Version\";s:5:\"1.4.1\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:7:\"10.3.29\";s:10:\"VersionPHP\";s:6:\"7.4.16\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:13:\"wpbaran_avada\";s:4:\"Hash\";s:35:\"668ae9f3bffefd431513_20210605152022\";s:8:\"NameHash\";s:49:\"wpbaran_avada_668ae9f3bffefd431513_20210605152022\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:59:\"wpbaran_avada_668ae9f3bffefd431513_20210605152022_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:61:\"wpbaran_avada_668ae9f3bffefd431513_20210605152022_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:31:\"/home/cp31505/public_html/avada\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-06-05 15:20:22\";s:7:\"Version\";s:5:\"1.4.1\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:7:\"10.3.29\";s:10:\"VersionPHP\";s:6:\"7.4.16\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:13:\"wpbaran_avada\";s:4:\"Hash\";s:35:\"668ae9f3bffefd431513_20210605152022\";s:8:\"NameHash\";s:49:\"wpbaran_avada_668ae9f3bffefd431513_20210605152022\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:63:\"wpbaran_avada_668ae9f3bffefd431513_20210605152022_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:62:\"wpbaran_avada_668ae9f3bffefd431513_20210605152022_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:5:{s:26:\"wp_actionscheduler_actions\";s:2:\"67\";s:25:\"wp_actionscheduler_claims\";s:1:\"0\";s:25:\"wp_actionscheduler_groups\";s:1:\"3\";s:23:\"wp_actionscheduler_logs\";s:3:\"201\";s:14:\"wp_commentmeta\";s:1:\"0\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:111:\"/home/cp31505/public_html/avada/wp-snapshots/tmp/wpbaran_avada_668ae9f3bffefd431513_20210605152022_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:40:\"/home/cp31505/public_html/avada/wp-admin\";i:1;s:50:\"/home/cp31505/public_html/avada/wp-content/uploads\";i:2;s:52:\"/home/cp31505/public_html/avada/wp-content/languages\";i:3;s:49:\"/home/cp31505/public_html/avada/wp-content/themes\";i:4;s:43:\"/home/cp31505/public_html/avada/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:31:\"/home/cp31505/public_html/avada\";i:1;s:42:\"/home/cp31505/public_html/avada/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:135;}");

/* INSERT TABLE DATA: wp_layerslider */
INSERT INTO `wp_layerslider` VALUES("1", "1", "Avada Captions Tall", "", "{\"properties\":{\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"title\":\"Avada Captions Tall\",\"slug\":\"\",\"width\":\"615px\",\"height\":\"434px\",\"responsive\":\"on\",\"maxwidth\":\"\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"twowayslideshow\":\"on\",\"skin\":\"borderlesslight\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 50px;\",\"thumb_nav\":\"disabled\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"imgpreload\":\"on\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":11816,\"background\":\"http:\\/\\/demo.wpbaran.ir\\/avada\\/wp-content\\/uploads\\/layerslider\\/Avada-Captions-Tall\\/portfolio_2.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #3\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada Theme\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"31px\",\"style\":\"color: #fff; \\r\\ntext-shadow: none; \\r\\nfont-size: 22px; \\r\\nline-height: 34px; \\r\\npadding: 0px 10px; \\r\\npadding-top: 1px;\\r\\nmargin: 0px; \\r\\nborder-width: 0px; \\r\\nborder-style: none; \\r\\nbackground-color:#000;\\t\\r\\nfont-family: PTSansRegular, Arial, Helvetica, sans-serif;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Amazingly Flexible\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"left\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"310px\",\"left\":\"31px\",\"style\":\"font-size: 42px; \\r\\nline-height: 45px; \\r\\nfont-family: museoslab500regular;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"We include so many features, shortcodes and options <br> that provides endless combinations for page layouts\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"364px\",\"left\":\"32px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":11815,\"background\":\"http:\\/\\/demo.wpbaran.ir\\/avada\\/wp-content\\/uploads\\/layerslider\\/Avada-Captions-Tall\\/portfolio_1.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #3\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada Is\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"31px\",\"style\":\"color: #fff; \\r\\ntext-shadow: none; \\r\\nfont-size: 22px; \\r\\nline-height: 34px; \\r\\npadding: 0px 10px; \\r\\npadding-top: 1px;\\r\\nmargin: 0px; \\r\\nborder-width: 0px; \\r\\nborder-style: none; \\r\\nbackground-color:#000;\\t\\r\\nfont-family: PTSansRegular, Arial, Helvetica, sans-serif;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Built For You\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"left\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"museoslab500regular\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"42px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"310px\",\"left\":\"31px\",\"style\":\"\\r\\n\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"We\\\\\'ve put so much thought and care into <br> making Avada user friendly for everyone\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"364px\",\"left\":\"32px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1555861016", "1555861016", "0", "0", "0", "0", "0", NULL, "0");
INSERT INTO `wp_layerslider` VALUES("2", "1", "Avada Full Width", "", "{\"properties\":{\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"title\":\"Avada Full Width\",\"slug\":\"\",\"width\":\"100%\",\"height\":\"400px\",\"maxwidth\":\"\",\"forceresponsive\":\"on\",\"responsiveunder\":\"960\",\"sublayercontainer\":\"960\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"twowayslideshow\":\"on\",\"skin\":\"avada\",\"backgroundcolor\":\"#f6f6f6\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"imgpreload\":\"on\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"6000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Clouds\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/slide_4.jpg\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Mac\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/mac.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"left\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"34px\",\"left\":\"506px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"iPad\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/ipad2.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"157px\",\"left\":\"457px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"iPhone\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/iphone.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"209px\",\"left\":\"403px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Avada Wordpress Theme\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada WP Theme\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"83px\",\"left\":\"1px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Made With Care...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Made With Care For Our Users\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"357\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"38\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"38\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"135px\",\"left\":\"1px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Lid est laborum ...\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Lid est laborum dolo rumes fugats untras. Et harums ser quidem<br \\/> \\r\\nrerum facilisdolores nemis omnis fugiats vitaes nemo minima<br \\/> \\r\\nrerums unsers sadips amets sadips ipsums\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"195px\",\"left\":\"2px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Purchase Now\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"[fusion_button link=\\\\\\\"http:\\/\\/themeforest.net\\/item\\/avada-responsive-multipurpose-theme\\/2833226?ref=ThemeFusion\\\\\\\" color=\\\\\\\"default\\\\\\\" size=\\\\\\\"\\\\\\\" type=\\\\\\\"\\\\\\\" shape=\\\\\\\"\\\\\\\" target=\\\\\\\"_self\\\\\\\" title=\\\\\\\"\\\\\\\" gradient_colors=\\\\\\\"|\\\\\\\" gradient_hover_colors=\\\\\\\"|\\\\\\\" accent_color=\\\\\\\"\\\\\\\" accent_hover_color=\\\\\\\"\\\\\\\" bevel_color=\\\\\\\"\\\\\\\" border_width=\\\\\\\"1px\\\\\\\" shadow=\\\\\\\"\\\\\\\" icon=\\\\\\\"\\\\\\\" icon_divider=\\\\\\\"yes\\\\\\\" icon_position=\\\\\\\"left\\\\\\\" modal=\\\\\\\"\\\\\\\" animation_type=\\\\\\\"0\\\\\\\" animation_direction=\\\\\\\"down\\\\\\\" animation_speed=\\\\\\\"0.1\\\\\\\" class=\\\\\\\"\\\\\\\" id=\\\\\\\"\\\\\\\"]Purchase Now![\\/fusion_button]\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"279px\",\"left\":\"1px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/slide_5.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"iPad\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/ipad.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\".2\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\".2\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"54px\",\"left\":\"-1px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Avada Is Better ...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada Is Better Than Ever\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"295\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"67px\",\"left\":\"666px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"100% Fully Responsive\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"100% Fully Responsive\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1100\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"250\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"106px\",\"left\":\"711px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"With Numerous\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"With Numerous\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"190\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"175px\",\"left\":\"770px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Additions & Optimizations\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Additions & Optimizations\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"285\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"215px\",\"left\":\"675px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"It Doesn\\\\\'t Get Better\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"It Doesn\\\\\'t Get Better Than This\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2100\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"342\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"289px\",\"left\":\"617px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/slide_3.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Create Fantastic...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Create Fantastic Sliders With Animations\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"430\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"82px\",\"left\":\"270px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Be Creative\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"BE CREATIVE\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"150px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"178px\",\"left\":\"81px\",\"style\":\"text-align: center; font-weight: normal; text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"The Possibilities Are...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"The Possibilities Are Endless And Results Stunning\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"515\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"275px\",\"left\":\"232px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1555861016", "1555861016", "0", "0", "0", "0", "0", NULL, "0");
INSERT INTO `wp_layerslider` VALUES("3", "1", "Avada Small Slider", "", "{\"properties\":{\"title\":\"Avada Small Slider\",\"width\":\"451px\",\"height\":\"220px\",\"responsive\":\"on\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"borderlesslight3d\",\"backgroundcolor\":\"#f6f6f6\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/iphone.png\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\",\"thumbnailId\":\"\"},\"sublayers\":[{\"subtitle\":\"iPhone\",\"type\":\"img\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/iphone.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"28px\",\"left\":\"73px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":\"\"},{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/logo.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"66px\",\"left\":\"194px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":\"\"},{\"subtitle\":\"Wordpress Theme\",\"type\":\"p\",\"image\":\"\",\"html\":\"Wordpress Theme\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"23px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"114px\",\"left\":\"195px\",\"style\":\"font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/ipad2.png\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\",\"thumbnailId\":\"\"},\"sublayers\":[{\"subtitle\":\"iPad\",\"type\":\"img\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/ipad2.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"33px\",\"left\":\"40px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":\"\"},{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/2013\\/10\\/logo.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"70px\",\"left\":\"235px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":\"\"},{\"subtitle\":\"#1 Selling Theme\",\"type\":\"p\",\"image\":\"\",\"html\":\"#1 Selling Theme\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"23px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"115px\",\"left\":\"234px\",\"style\":\"font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1555861016", "1555861016", "0", "0", "0", "0", "0", NULL, "0");
INSERT INTO `wp_layerslider` VALUES("4", "1", "Avada Transparent Header", "", "{\"properties\":{\"post_type\":[\"attachment\"],\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"title\":\"Avada Transparent Header\",\"slug\":\"\",\"width\":\"100%\",\"height\":\"650px\",\"maxwidth\":\"\",\"forceresponsive\":\"on\",\"responsiveunder\":\"940\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"loops\":\"0\",\"skin\":\"v5\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"imgpreload\":\"on\",\"lazyload\":\"on\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"75,79\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/ls_bkgd_color1.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"11000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"5-1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_1.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right -50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"390px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-2\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_2.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1300\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left -50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"390px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-3\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_3.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1600\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-4\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_4.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1900\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"right 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-5\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_5.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right 150% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"145px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-6\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/A2_6.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 150% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"145px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"AVADA\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"AVADA\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left bottom 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"340px\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5px\\\\\\\"}\",\"top\":\"132px\",\"left\":\"294px\",\"style\":\"font-weight: 500; text-align: center;  \\r\\nletter-spacing: .1em;\\r\\nfont-family: museoslab500regular; line-height: 115%;\\r\\nopacity: .3;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"POWERFUL OPTIONS\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"POWERFUL OPTIONS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fa6b4b\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4px\\\\\\\"}\",\"top\":\"242px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"for just about anything you need!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"for just about anything you need to help customize!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"25% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"288px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"AMAZING SLIDERS\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"AMAZING SLIDERS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fa6b4b\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4px\\\\\\\"}\",\"top\":\"343px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"slide, fade, scale, skew and rotate layers!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"slide, fade, scale, skew and rotate your individual layers!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5100\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"25% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"391px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"OUTSTANDING SUPPORT\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"OUTSTANDING SUPPORT\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fa6b4b\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4px\\\\\\\"}\",\"top\":\"445px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"trust in us for after sale support!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"trust in us for after sale support, we got your back!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"25% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"490px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #14\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/html5-color.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"6300\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"189px\",\"left\":\"990px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #14 copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/vimeo-color.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"6500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"305px\",\"left\":\"990px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #14 copy copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/youtube-color.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"6700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"430px\",\"left\":\"990px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"21,105\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/bg6b.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"8000\",\"timeshift\":\"-1000\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"circle\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/circle.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"115px\",\"left\":\"50%\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"circle 2\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"http:\\/\\/theme-fusion.com\\/avadaxml\\/wp-content\\/uploads\\/layerslider\\/Transparent-Header-Slider\\/circle.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"115px\",\"left\":\"50%\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"&\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"&\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"200px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#f06a52\\\\\\\"}\",\"top\":\"65px\",\"left\":\"2px\",\"style\":\"font-weight: 300; opacity: .4\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"all these features\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"ALL THIS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"29px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#bd5949\\\\\\\"}\",\"top\":\"149px\",\"left\":\"0px\",\"style\":\"font-weight: 300; background: white; background: rgba(255,255,255,.85)\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"much more!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"much more!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"50\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"-60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"-60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"29px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#bd5949\\\\\\\"}\",\"top\":\"199px\",\"left\":\"45px\",\"style\":\"font-weight: 500;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"to create\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"...to create\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"right bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right bottom 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#bd5949\\\\\\\"}\",\"top\":\"422px\",\"left\":\"958px\",\"style\":\"font-weight: 500; text-align: right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"the best slider\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"THE BEST SLIDER\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3250\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"260px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#f06a52\\\\\\\"}\",\"top\":\"463px\",\"left\":\"828px\",\"style\":\"font-weight: 300; text-align: right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"with no compromises\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"with no compromises!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'Indie Flower\\\\\'\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#d9482b\\\\\\\"}\",\"top\":\"512px\",\"left\":\"829px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"ls5box\",\"media\":\"img\",\"type\":\"p\",\"imageId\":11817,\"image\":\"http:\\/\\/demo.wpbaran.ir\\/avada\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/ipad.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"147px\",\"left\":\"289px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1555861016", "1555861016", "0", "0", "0", "0", "0", NULL, "0");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://demo.wpbaran.ir/avada", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://demo.wpbaran.ir/avada", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Avada Classic", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "wpbaran_admin@wpbaran.ir", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "Y-m-d", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("6352", "wpseo", "a:20:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:4:\"13.2\";s:20:\"disableadvanced_meta\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1581521318;s:13:\"myyoast-oauth\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("6353", "wpseo_titles", "a:81:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:51:\"%%name%%, نویسنده در %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:84:\"شما برای %%searchphrase%% جستجو کردید %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:45:\"صفحه پیدا نشد %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:79:\"نوشته %%POSTLINK%% اولین بار در %%BLOGLINK%%. پدیدار شد.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:38:\"خطای 404: صفحه پیدا نشد\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:30:\"بایگانی‌ها برای\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:8:\"خانه\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:39:\"شما جستجو نمودید برای\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:14:\"person_logo_id\";i:0;s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:15:\"company_logo_id\";i:0;s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:18:\"title-tax-category\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:18:\"title-tribe_events\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tribe_events\";s:0:\"\";s:20:\"noindex-tribe_events\";b:0;s:21:\"showdate-tribe_events\";b:0;s:31:\"display-metabox-pt-tribe_events\";b:1;s:31:\"post_types-tribe_events-maintax\";i:0;s:28:\"title-ptarchive-tribe_events\";s:58:\"بایگانی %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-ptarchive-tribe_events\";s:0:\"\";s:30:\"bctitle-ptarchive-tribe_events\";s:0:\"\";s:30:\"noindex-ptarchive-tribe_events\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("6354", "wpseo_social", "a:19:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("6355", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("6358", "woocommerce_store_address", "آدرس تنظیم نشده است", "yes");
INSERT INTO `wp_options` VALUES("6359", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("6360", "woocommerce_store_city", "فومن", "yes");
INSERT INTO `wp_options` VALUES("6361", "woocommerce_default_country", "IR:GIL", "yes");
INSERT INTO `wp_options` VALUES("6362", "woocommerce_store_postcode", "1234567890", "yes");
INSERT INTO `wp_options` VALUES("6363", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("6364", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6365", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6366", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("6367", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6368", "woocommerce_default_customer_address", "geolocation", "yes");
INSERT INTO `wp_options` VALUES("6369", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("6370", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("6371", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("6372", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("6373", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("6374", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("6375", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("6376", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("6377", "woocommerce_shop_page_id", "4097", "yes");
INSERT INTO `wp_options` VALUES("6378", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("6379", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("6380", "woocommerce_placeholder_image", "11874", "yes");
INSERT INTO `wp_options` VALUES("6381", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("6382", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("6383", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("6384", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("6385", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("6386", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("6387", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("6388", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("6389", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("6390", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("6391", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("6392", "woocommerce_stock_email_recipient", "wpbaran_admin@wpbaran.ir", "no");
INSERT INTO `wp_options` VALUES("6393", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("6394", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("6395", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("6396", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("6397", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("6398", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("6399", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("6400", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("6401", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("6402", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("6403", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("6405", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("6406", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("6407", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("6408", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("6409", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("6410", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("6411", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("6412", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("6413", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("6414", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("6415", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("6416", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wp_options` VALUES("6417", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("6418", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("6419", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("6420", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("6421", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `wp_options` VALUES("6422", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `wp_options` VALUES("6423", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("6424", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("6425", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("6426", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("6427", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("6428", "woocommerce_email_from_name", "Avada Classic", "no");
INSERT INTO `wp_options` VALUES("6429", "woocommerce_email_from_address", "wpbaran_admin@wpbaran.ir", "no");
INSERT INTO `wp_options` VALUES("6430", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("6431", "woocommerce_email_footer_text", "{site_title}<br/>Built with <a href=\"https://woocommerce.com/\">WooCommerce</a>", "no");
INSERT INTO `wp_options` VALUES("6432", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("6433", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("6434", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("6435", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("6436", "woocommerce_cart_page_id", "11935", "yes");
INSERT INTO `wp_options` VALUES("6437", "woocommerce_checkout_page_id", "11936", "yes");
INSERT INTO `wp_options` VALUES("6438", "woocommerce_myaccount_page_id", "11937", "yes");
INSERT INTO `wp_options` VALUES("6439", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("6440", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("6441", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("6442", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("6443", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("6444", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("6445", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("6446", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("6447", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("6448", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("6449", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("6450", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("6451", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("6452", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("6453", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("6454", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("6455", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("6533", "_bbp_db_version", "263", "yes");
INSERT INTO `wp_options` VALUES("6456", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("6457", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("6458", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:14:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:34:\"advanced-custom-fields-pro/acf.php\";i:2;s:19:\"bbpress/bbpress.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:27:\"convertplug/convertplug.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:33:\"fusion-builder/fusion-builder.php\";i:7;s:27:\"fusion-core/fusion-core.php\";i:8;s:59:\"fusion-white-label-branding/fusion-white-label-branding.php\";i:9;s:11:\"pwa/pwa.php\";i:10;s:23:\"revslider/revslider.php\";i:11;s:43:\"the-events-calendar/the-events-calendar.php\";i:12;s:27:\"woocommerce/woocommerce.php\";i:13;s:21:\"wp-reset/wp-reset.php\";}", "yes");
INSERT INTO `wp_options` VALUES("28477", "_transient_timeout_tribe_plugin_upgrade_notice-7b0394f0", "1622992795", "no");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "Avada", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "Avada", "yes");
INSERT INTO `wp_options` VALUES("28405", "finished_updating_comment_type", "0", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:3:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:7;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:10:{i:3;a:12:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:423:\"<img src=\"http://demo.wpbaran.ir/avada/wp-content/uploads/2016/04/logo_white_big.png\" alt=\"\" />\r\n<p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.</p>\";s:6:\"filter\";b:1;s:6:\"visual\";b:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:10;a:12:{s:5:\"title\";s:44:\"این یک ابزارک سفارشی است\";s:4:\"text\";s:605:\"این کشویی نوار را می توان در گزینه های تم روشن یا خاموش، و می توانید هر گونه ویجت شما را پرتاب در آن و یا حتی پر کردن آن را با کد HTML سفارشی خود را. مناسب برای جذب توجه بینندگان شما. بین 1، 2، 3 یا 4 ستون را انتخاب کنید، رنگ پس زمینه، رنگ تقسیم ویجت را تنظیم کنید، شفافیت فعال، مرز بالا و یا به طور کامل آن را بر روی دسکتاپ و موبایل غیر فعال کنید.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:11;a:12:{s:5:\"title\";s:44:\"این یک ابزارک سفارشی است\";s:4:\"text\";s:605:\"این کشویی نوار را می توان در گزینه های تم روشن یا خاموش، و می توانید هر گونه ویجت شما را پرتاب در آن و یا حتی پر کردن آن را با کد HTML سفارشی خود را. مناسب برای جذب توجه بینندگان شما. بین 1، 2، 3 یا 4 ستون را انتخاب کنید، رنگ پس زمینه، رنگ تقسیم ویجت را تنظیم کنید، شفافیت فعال، مرز بالا و یا به طور کامل آن را بر روی دسکتاپ و موبایل غیر فعال کنید.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:8;a:12:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1219:\"[fusion_accordion][fusion_toggle title=\"خدمات شرکت ما\"]لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.[/fusion_toggle]\r\n[fusion_toggle title=\"نمونه کارهای ما\"]لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.[/fusion_toggle]\r\n[fusion_toggle title=\"قالب آوادا وردپـرس بـاران\"]لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.[/fusion_toggle]\r\n[/fusion_accordion]\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:5;a:12:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:894:\"[fusion_testimonials]\r\n[fusion_testimonial name=\"مجتبی تبسمی\" company=\"وردپرس باران\"]لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی. [/fusion_testimonial]\r\n[fusion_testimonial name=\"مجید تبسمی\" company=\"وردپرس باران\"]لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.[/fusion_testimonial]\r\n[/fusion_testimonials]\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:9;a:12:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1605:\"[fusion_accordion][fusion_toggle title=\"مرجع آموزش وردپرس\"]لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.[/fusion_toggle]\r\n[fusion_toggle title=\"مرجع قالب وردپرس\"]لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.[/fusion_toggle]\r\n[fusion_toggle title=\"مرجع افزوه وردپرس\"]لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.[/fusion_toggle]\r\n[fusion_toggle title=\"مرجع وردپرس ایران\"]لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.[/fusion_toggle][/fusion_accordion]\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:4;a:12:{s:5:\"title\";s:30:\"ابزارک متنی ساده\";s:4:\"text\";s:319:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:13;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:363:\"[fusion_map address=\"new york city, ny | 579 Allen Road Basking Ridge, NJ 07920 | Mount Arlington, NJ 07856\" type=\"roadmap\" width=\"244px\" height=\"150px\" zoom=\"8\" scrollwheel=\"false\" scale=\"false\" zoom_pancontrol=\"false\" popup=\"false\"][/fusion_map]\r\n<br />\r\n<strong>Come Check Us out!</strong><br />\r\nMonday Through Friday: 8am-8pm<br />\r\nPhone: 800-555-5555\r\n\r\n\r\n\";s:6:\"filter\";b:0;}i:12;a:12:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<img src=\"http://demo.wpbaran.ir/avada/wp-content/uploads/2016/04/megamenu_image.jpg\" alt=\"\" />\r\n<p>قالب آوادا امکان ساخت مگامنو با تعداد ستون 1 تا 6 را دارد. ترجمه فارسی وردپرس باران</p>\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:2:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:21:\"wp-reset/wp-reset.php\";a:2:{i:0;s:8:\"WP_Reset\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "10709", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "initial_db_version", "44719", "yes");
INSERT INTO `wp_options` VALUES("94", "wp_user_roles", "a:14:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:157:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:9:\"access_cp\";b:1;s:27:\"access_white_label_branding\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:75:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:30:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:13:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:30:{s:9:\"keep_gate\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:17:\"assign_moderators\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:18:\"edit_others_forums\";b:1;s:13:\"delete_forums\";b:1;s:20:\"delete_others_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:1:{s:8:\"spectate\";b:1;}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:0;s:11:\"participate\";b:0;s:8:\"moderate\";b:0;s:8:\"throttle\";b:0;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:0;s:11:\"edit_forums\";b:0;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:0;s:18:\"read_hidden_forums\";b:0;s:14:\"publish_topics\";b:0;s:11:\"edit_topics\";b:0;s:18:\"edit_others_topics\";b:0;s:13:\"delete_topics\";b:0;s:20:\"delete_others_topics\";b:0;s:19:\"read_private_topics\";b:0;s:15:\"publish_replies\";b:0;s:12:\"edit_replies\";b:0;s:19:\"edit_others_replies\";b:0;s:14:\"delete_replies\";b:0;s:21:\"delete_others_replies\";b:0;s:20:\"read_private_replies\";b:0;s:17:\"manage_topic_tags\";b:0;s:15:\"edit_topic_tags\";b:0;s:17:\"delete_topic_tags\";b:0;s:17:\"assign_topic_tags\";b:0;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:26:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:17:\"assign_moderators\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:8:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("96", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_search", "a:4:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-posts", "a:5:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:5;a:11:{s:5:\"title\";s:26:\"آخرین نوشته ها\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:6;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;}i:3;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "sidebars_widgets", "a:19:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:9:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";i:6;s:18:\"pyre_tabs-widget-6\";i:7;s:21:\"recent_works-widget-4\";i:8;s:14:\"recent-posts-5\";}s:21:\"avada-footer-widget-1\";a:1:{i:0;s:6:\"text-3\";}s:21:\"avada-footer-widget-2\";a:1:{i:0;s:14:\"recent-posts-6\";}s:21:\"avada-footer-widget-3\";a:1:{i:0;s:12:\"categories-7\";}s:21:\"avada-footer-widget-4\";a:1:{i:0;s:21:\"recent_works-widget-6\";}s:25:\"avada-slidingbar-widget-1\";a:1:{i:0;s:7:\"text-10\";}s:25:\"avada-slidingbar-widget-2\";a:1:{i:0;s:7:\"text-11\";}s:25:\"avada-slidingbar-widget-3\";a:0:{}s:35:\"avada-custom-sidebar-contactsidebar\";a:3:{i:0;s:21:\"contact_info-widget-2\";i:1;s:6:\"text-8\";i:2;s:21:\"social_links-widget-3\";}s:24:\"avada-custom-sidebar-faq\";a:2:{i:0;s:8:\"search-3\";i:1;s:18:\"pyre_tabs-widget-5\";}s:36:\"avada-custom-sidebar-homepagesidebar\";a:5:{i:0;s:8:\"search-4\";i:1;s:18:\"pyre_tabs-widget-4\";i:2;s:21:\"recent_works-widget-5\";i:3;s:14:\"recent-posts-3\";i:4;s:6:\"text-5\";}s:30:\"avada-custom-sidebar-portfolio\";a:3:{i:0;s:18:\"pyre_tabs-widget-3\";i:1;s:6:\"text-9\";i:2;s:6:\"text-4\";}s:30:\"avada-custom-sidebar-megamenu1\";a:1:{i:0;s:7:\"text-13\";}s:30:\"avada-custom-sidebar-megamenu2\";a:1:{i:0;s:7:\"text-12\";}s:28:\"avada-custom-sidebar-twitter\";a:0:{}s:32:\"avada-custom-sidebar-pagewidget1\";a:0:{}s:32:\"avada-custom-sidebar-pagewidget2\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("149", "widget_ad_125_125-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("150", "widget_fusion_author-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("151", "widget_contact_info-widget", "a:2:{i:2;a:17:{s:5:\"title\";s:23:\"اطلاعات تماس\";s:7:\"address\";s:36:\"فومن خیابات طالقانی\";s:5:\"phone\";s:11:\"09123456789\";s:3:\"fax\";s:11:\"09123456789\";s:5:\"email\";s:20:\"info@yourwebsite.com\";s:3:\"web\";s:22:\"http://yourwebsite.com\";s:8:\"emailtxt\";s:20:\"info@yourwebsite.com\";s:6:\"webtxt\";s:15:\"Yourwebsite.com\";s:6:\"mobile\";s:0:\"\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("143", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"wpbaran_admin@wpbaran.ir\";s:7:\"version\";s:5:\"5.4.6\";s:9:\"timestamp\";i:1621301926;}", "no");
INSERT INTO `wp_options` VALUES("145", "current_theme", "Avada", "yes");
INSERT INTO `wp_options` VALUES("146", "theme_mods_Avada", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:9:\"404_pages\";i:28;s:15:\"main_navigation\";i:29;s:14:\"top_navigation\";i:31;}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("147", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("148", "avada_version", "7.3.1", "yes");
INSERT INTO `wp_options` VALUES("152", "widget_pyre_tabs-widget", "a:5:{i:6;a:8:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:1:\"3\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:9:\"show_tags\";N;s:7:\"orderby\";s:16:\"Highest Comments\";}i:5;a:8:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:2:\"20\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:9:\"show_tags\";N;s:7:\"orderby\";s:16:\"Highest Comments\";}i:4;a:7:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:2:\"20\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:9:\"show_tags\";N;}i:3;a:8:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:2:\"20\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:9:\"show_tags\";N;s:7:\"orderby\";s:16:\"Highest Comments\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("153", "widget_recent_works-widget", "a:4:{i:4;a:10:{s:5:\"title\";s:21:\"آخرین کارها\";s:6:\"number\";s:1:\"6\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:6;a:10:{s:5:\"title\";s:28:\"آخرین کارهای ما\";s:6:\"number\";s:1:\"6\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:5;a:10:{s:5:\"title\";s:28:\"آخرین کارهای ما\";s:6:\"number\";s:1:\"6\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("154", "widget_tweets-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("155", "widget_flickr-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("156", "widget_social_links-widget", "a:2:{i:3;a:49:{s:5:\"title\";s:35:\"شبکه های اجتماعی ما\";s:8:\"rss_link\";s:1:\"#\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:13:\"dribbble_link\";s:1:\"#\";s:11:\"google_link\";s:1:\"#\";s:13:\"linkedin_link\";s:1:\"#\";s:12:\"blogger_link\";s:1:\"#\";s:11:\"tumblr_link\";s:1:\"#\";s:11:\"reddit_link\";s:0:\"\";s:10:\"yahoo_link\";s:1:\"#\";s:15:\"deviantart_link\";s:1:\"#\";s:10:\"vimeo_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:9:\"digg_link\";s:1:\"#\";s:11:\"flickr_link\";s:1:\"#\";s:11:\"forrst_link\";s:1:\"#\";s:12:\"myspace_link\";s:0:\"\";s:10:\"skype_link\";s:1:\"#\";s:10:\"linktarget\";s:0:\"\";s:10:\"icon_color\";s:0:\"\";s:10:\"boxed_icon\";s:3:\"Yes\";s:11:\"boxed_color\";s:0:\"\";s:17:\"boxed_icon_radius\";s:3:\"4px\";s:11:\"tooltip_pos\";s:3:\"Top\";s:11:\"show_custom\";s:2:\"No\";s:14:\"instagram_link\";s:1:\"#\";s:11:\"paypal_link\";s:0:\"\";s:12:\"dropbox_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:15:\"icons_font_size\";s:4:\"16px\";s:10:\"color_type\";s:6:\"custom\";s:18:\"boxed_icon_padding\";s:3:\"8px\";s:12:\"spotify_link\";s:0:\"\";s:13:\"whatsapp_link\";s:1:\"#\";s:9:\"xing_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:10:\"email_link\";s:1:\"#\";s:6:\"use_to\";s:2:\"No\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("157", "widget_facebook-like-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("158", "widget_menu-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("159", "widget_avada-vertical-menu-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "cron", "a:24:{i:1622906329;a:1:{s:28:\"wp_1_wc_privacy_cleanup_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:37:\"wp_1_wc_privacy_cleanup_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1622906339;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1622906449;a:1:{s:28:\"wp_update_comment_type_batch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1622906497;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1622906919;a:2:{s:24:\"tribe_common_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1622907038;a:1:{s:22:\"wp_https_support_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1622907192;a:4:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1622907198;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1622907199;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1622909039;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1622909046;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1622909851;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1622917051;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1622923200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1622926880;a:1:{s:42:\"wpseo_send_tracking_data_after_core_update\";a:1:{s:32:\"431014e4a761ea216e9a35f20aaec61c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";b:1;}}}i:1622927851;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1622938620;a:1:{s:30:\"tribe_schedule_transient_purge\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1622948482;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1622991838;a:1:{s:16:\"tribe_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1622991840;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1622992661;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1623424897;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1624202311;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("113", "theme_mods_twentynineteen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1555860820;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("162", "_transient_timeout_avada_demos", "1556465622", "no");
INSERT INTO `wp_options` VALUES("212", "widget_layerslider_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6534", "cp_new_bg_type", "1", "yes");
INSERT INTO `wp_options` VALUES("6539", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("28317", "_site_transient_timeout_fusion_l10n_api_avada", "1622910736", "no");
INSERT INTO `wp_options` VALUES("28318", "_site_transient_fusion_l10n_api_avada", "a:1:{s:12:\"translations\";a:121:{i:0;a:8:{s:8:\"language\";s:2:\"af\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-af.zip\";}i:1;a:8:{s:8:\"language\";s:2:\"ar\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ar.zip\";}i:2;a:8:{s:8:\"language\";s:3:\"ary\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ary.zip\";}i:3;a:8:{s:8:\"language\";s:2:\"as\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-as.zip\";}i:4;a:8:{s:8:\"language\";s:2:\"az\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-az.zip\";}i:5;a:8:{s:8:\"language\";s:3:\"azb\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-azb.zip\";}i:6;a:8:{s:8:\"language\";s:3:\"bel\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-bel.zip\";}i:7;a:8:{s:8:\"language\";s:5:\"bg_BG\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-bg_BG.zip\";}i:8;a:8:{s:8:\"language\";s:5:\"bn_BD\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-bn_BD.zip\";}i:9;a:8:{s:8:\"language\";s:2:\"bo\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-bo.zip\";}i:10;a:8:{s:8:\"language\";s:5:\"bs_BA\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-bs_BA.zip\";}i:11;a:8:{s:8:\"language\";s:2:\"ca\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ca.zip\";}i:12;a:8:{s:8:\"language\";s:3:\"ceb\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ceb.zip\";}i:13;a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-cs_CZ.zip\";}i:14;a:8:{s:8:\"language\";s:2:\"cy\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-cy.zip\";}i:15;a:8:{s:8:\"language\";s:5:\"da_DK\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-da_DK.zip\";}i:16;a:8:{s:8:\"language\";s:5:\"de_AT\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-de_AT.zip\";}i:17;a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:102:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-de_CH_informal.zip\";}i:18;a:8:{s:8:\"language\";s:5:\"de_CH\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-de_CH.zip\";}i:19;a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:100:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-de_DE_formal.zip\";}i:20;a:8:{s:8:\"language\";s:5:\"de_DE\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-de_DE.zip\";}i:21;a:8:{s:8:\"language\";s:3:\"dzo\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-dzo.zip\";}i:22;a:8:{s:8:\"language\";s:2:\"el\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-el.zip\";}i:23;a:8:{s:8:\"language\";s:5:\"en_GB\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-en_GB.zip\";}i:24;a:8:{s:8:\"language\";s:5:\"en_ZA\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-en_ZA.zip\";}i:25;a:8:{s:8:\"language\";s:5:\"en_NZ\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-en_NZ.zip\";}i:26;a:8:{s:8:\"language\";s:5:\"en_CA\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-en_CA.zip\";}i:27;a:8:{s:8:\"language\";s:5:\"en_AU\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-en_AU.zip\";}i:28;a:8:{s:8:\"language\";s:2:\"eo\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-eo.zip\";}i:29;a:8:{s:8:\"language\";s:5:\"es_AR\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_AR.zip\";}i:30;a:8:{s:8:\"language\";s:5:\"es_CO\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_CO.zip\";}i:31;a:8:{s:8:\"language\";s:5:\"es_VE\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_VE.zip\";}i:32;a:8:{s:8:\"language\";s:5:\"es_UY\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_UY.zip\";}i:33;a:8:{s:8:\"language\";s:5:\"es_CR\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_CR.zip\";}i:34;a:8:{s:8:\"language\";s:5:\"es_CL\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_CL.zip\";}i:35;a:8:{s:8:\"language\";s:5:\"es_GT\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_GT.zip\";}i:36;a:8:{s:8:\"language\";s:5:\"es_PE\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_PE.zip\";}i:37;a:8:{s:8:\"language\";s:5:\"es_ES\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_ES.zip\";}i:38;a:8:{s:8:\"language\";s:5:\"es_MX\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-es_MX.zip\";}i:39;a:8:{s:8:\"language\";s:2:\"et\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-et.zip\";}i:40;a:8:{s:8:\"language\";s:2:\"eu\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-eu.zip\";}i:41;a:8:{s:8:\"language\";s:5:\"fa_IR\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-fa_IR.zip\";}i:42;a:8:{s:8:\"language\";s:2:\"fi\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-fi.zip\";}i:43;a:8:{s:8:\"language\";s:5:\"fr_FR\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-fr_FR.zip\";}i:44;a:8:{s:8:\"language\";s:5:\"fr_CA\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-fr_CA.zip\";}i:45;a:8:{s:8:\"language\";s:5:\"fr_BE\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-fr_BE.zip\";}i:46;a:8:{s:8:\"language\";s:3:\"fur\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-fur.zip\";}i:47;a:8:{s:8:\"language\";s:2:\"gd\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-gd.zip\";}i:48;a:8:{s:8:\"language\";s:5:\"gl_ES\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-gl_ES.zip\";}i:49;a:8:{s:8:\"language\";s:2:\"gu\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-gu.zip\";}i:50;a:8:{s:8:\"language\";s:3:\"haz\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-haz.zip\";}i:51;a:8:{s:8:\"language\";s:5:\"he_IL\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-he_IL.zip\";}i:52;a:8:{s:8:\"language\";s:5:\"hi_IN\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-hi_IN.zip\";}i:53;a:8:{s:8:\"language\";s:2:\"hr\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-hr.zip\";}i:54;a:8:{s:8:\"language\";s:3:\"hsb\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-hsb.zip\";}i:55;a:8:{s:8:\"language\";s:5:\"hu_HU\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-hu_HU.zip\";}i:56;a:8:{s:8:\"language\";s:2:\"hy\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-hy.zip\";}i:57;a:8:{s:8:\"language\";s:5:\"id_ID\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-id_ID.zip\";}i:58;a:8:{s:8:\"language\";s:5:\"is_IS\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-is_IS.zip\";}i:59;a:8:{s:8:\"language\";s:5:\"it_IT\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-it_IT.zip\";}i:60;a:8:{s:8:\"language\";s:2:\"ja\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ja.zip\";}i:61;a:8:{s:8:\"language\";s:5:\"jv_ID\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nutugne\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-jv_ID.zip\";}i:62;a:8:{s:8:\"language\";s:5:\"ka_GE\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ka_GE.zip\";}i:63;a:8:{s:8:\"language\";s:3:\"kab\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-kab.zip\";}i:64;a:8:{s:8:\"language\";s:2:\"kk\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-kk.zip\";}i:65;a:8:{s:8:\"language\";s:2:\"km\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-km.zip\";}i:66;a:8:{s:8:\"language\";s:2:\"kn\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರೆಸಿ\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-kn.zip\";}i:67;a:8:{s:8:\"language\";s:5:\"ko_KR\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ko_KR.zip\";}i:68;a:8:{s:8:\"language\";s:3:\"ckb\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ckb.zip\";}i:69;a:8:{s:8:\"language\";s:2:\"lo\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ຕໍ່\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-lo.zip\";}i:70;a:8:{s:8:\"language\";s:5:\"lt_LT\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-lt_LT.zip\";}i:71;a:8:{s:8:\"language\";s:2:\"lv\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-lv.zip\";}i:72;a:8:{s:8:\"language\";s:5:\"mk_MK\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-mk_MK.zip\";}i:73;a:8:{s:8:\"language\";s:5:\"ml_IN\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ml_IN.zip\";}i:74;a:8:{s:8:\"language\";s:2:\"mn\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-mn.zip\";}i:75;a:8:{s:8:\"language\";s:2:\"mr\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-mr.zip\";}i:76;a:8:{s:8:\"language\";s:5:\"ms_MY\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ms_MY.zip\";}i:77;a:8:{s:8:\"language\";s:5:\"my_MM\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-my_MM.zip\";}i:78;a:8:{s:8:\"language\";s:5:\"nb_NO\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-nb_NO.zip\";}i:79;a:8:{s:8:\"language\";s:5:\"ne_NP\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"जारीराख्नु \";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ne_NP.zip\";}i:80;a:8:{s:8:\"language\";s:5:\"nl_BE\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-nl_BE.zip\";}i:81;a:8:{s:8:\"language\";s:5:\"nl_NL\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-nl_NL.zip\";}i:82;a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:100:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-nl_NL_formal.zip\";}i:83;a:8:{s:8:\"language\";s:5:\"nn_NO\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-nn_NO.zip\";}i:84;a:8:{s:8:\"language\";s:3:\"oci\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-oci.zip\";}i:85;a:8:{s:8:\"language\";s:5:\"pa_IN\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-pa_IN.zip\";}i:86;a:8:{s:8:\"language\";s:5:\"pl_PL\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-pl_PL.zip\";}i:87;a:8:{s:8:\"language\";s:2:\"ps\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ps.zip\";}i:88;a:8:{s:8:\"language\";s:5:\"pt_PT\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-pt_PT.zip\";}i:89;a:8:{s:8:\"language\";s:5:\"pt_AO\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-pt_AO.zip\";}i:90;a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:98:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-pt_PT_ao90.zip\";}i:91;a:8:{s:8:\"language\";s:5:\"pt_BR\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-pt_BR.zip\";}i:92;a:8:{s:8:\"language\";s:3:\"rhg\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-rhg.zip\";}i:93;a:8:{s:8:\"language\";s:5:\"ro_RO\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ro_RO.zip\";}i:94;a:8:{s:8:\"language\";s:5:\"ru_RU\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ru_RU.zip\";}i:95;a:8:{s:8:\"language\";s:3:\"sah\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-sah.zip\";}i:96;a:8:{s:8:\"language\";s:3:\"snd\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:2:\"sd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-snd.zip\";}i:97;a:8:{s:8:\"language\";s:5:\"si_LK\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-si_LK.zip\";}i:98;a:8:{s:8:\"language\";s:5:\"sk_SK\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-sk_SK.zip\";}i:99;a:8:{s:8:\"language\";s:3:\"skr\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-skr.zip\";}i:100;a:8:{s:8:\"language\";s:5:\"sl_SI\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-sl_SI.zip\";}i:101;a:8:{s:8:\"language\";s:2:\"sq\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-sq.zip\";}i:102;a:8:{s:8:\"language\";s:5:\"sr_RS\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-sr_RS.zip\";}i:103;a:8:{s:8:\"language\";s:5:\"sv_SE\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-sv_SE.zip\";}i:104;a:8:{s:8:\"language\";s:2:\"sw\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-sw.zip\";}i:105;a:8:{s:8:\"language\";s:3:\"szl\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-szl.zip\";}i:106;a:8:{s:8:\"language\";s:5:\"ta_IN\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ta_IN.zip\";}i:107;a:8:{s:8:\"language\";s:2:\"te\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-te.zip\";}i:108;a:8:{s:8:\"language\";s:2:\"th\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-th.zip\";}i:109;a:8:{s:8:\"language\";s:2:\"tl\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-tl.zip\";}i:110;a:8:{s:8:\"language\";s:5:\"tr_TR\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-tr_TR.zip\";}i:111;a:8:{s:8:\"language\";s:5:\"tt_RU\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-tt_RU.zip\";}i:112;a:8:{s:8:\"language\";s:3:\"tah\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:91:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-tah.zip\";}i:113;a:8:{s:8:\"language\";s:5:\"ug_CN\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ug_CN.zip\";}i:114;a:8:{s:8:\"language\";s:2:\"uk\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-uk.zip\";}i:115;a:8:{s:8:\"language\";s:2:\"ur\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-ur.zip\";}i:116;a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-uz_UZ.zip\";}i:117;a:8:{s:8:\"language\";s:2:\"vi\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:90:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-vi.zip\";}i:118;a:8:{s:8:\"language\";s:5:\"zh_CN\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-zh_CN.zip\";}i:119;a:8:{s:8:\"language\";s:5:\"zh_TW\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-zh_TW.zip\";}i:120;a:8:{s:8:\"language\";s:5:\"zh_HK\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}s:7:\"version\";s:5:\"7.3.1\";s:7:\"updated\";s:19:\"2021-04-14 13:19:47\";s:7:\"package\";s:93:\"https://raw.githubusercontent.com/Theme-Fusion/Localization-l10n/master/Avada/Avada-zh_HK.zip\";}}}", "no");
INSERT INTO `wp_options` VALUES("6475", "_transient_woocommerce_webhook_ids", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6476", "tribe_events_calendar_options", "a:8:{s:14:\"schema-version\";s:7:\"5.5.0.1\";s:21:\"previous_ecp_versions\";a:3:{i:0;s:1:\"0\";i:1;s:5:\"4.8.2\";i:2;s:7:\"5.0.3.1\";}s:18:\"latest_ecp_version\";s:7:\"5.5.0.1\";s:27:\"recurring_events_are_hidden\";s:6:\"hidden\";s:8:\"did_init\";b:1;s:19:\"tribeEventsTemplate\";s:0:\"\";s:16:\"tribeEnableViews\";a:3:{i:0;s:4:\"list\";i:1;s:5:\"month\";i:2;s:3:\"day\";}s:10:\"viewOption\";s:4:\"list\";}", "yes");
INSERT INTO `wp_options` VALUES("6477", "widget_bbp_login_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6478", "widget_bbp_views_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6479", "widget_bbp_search_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6480", "widget_bbp_forums_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6481", "widget_bbp_topics_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6482", "widget_bbp_replies_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6483", "widget_bbp_stats_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6484", "widget_convertplug_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6485", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6486", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6487", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6488", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6489", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6490", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6491", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6492", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6493", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6494", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6495", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6496", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6497", "widget_tribe-events-list-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6500", "tribe_last_save_post", "1622906252.2163", "yes");
INSERT INTO `wp_options` VALUES("6339", "convert_plug_modules", "a:3:{i:0;s:11:\"Modal_Popup\";i:1;s:8:\"Info_Bar\";i:2;s:14:\"Slide_In_Popup\";}", "yes");
INSERT INTO `wp_options` VALUES("6340", "ultimate_google_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6341", "ultimate_selected_google_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6342", "convert_plug_redirect", "", "yes");
INSERT INTO `wp_options` VALUES("6343", "bsf_force_check_extensions", "", "no");
INSERT INTO `wp_options` VALUES("6344", "cp_is_new_user", "1", "yes");
INSERT INTO `wp_options` VALUES("6345", "cp_previous_version", "3.5.18", "yes");
INSERT INTO `wp_options` VALUES("6349", "wp-reset", "a:4:{s:4:\"meta\";a:3:{s:13:\"first_version\";s:4:\"1.55\";s:13:\"first_install\";i:1581521318;s:11:\"reset_count\";i:0;}s:17:\"dismissed_notices\";a:1:{s:7:\"welcome\";b:1;}s:8:\"last_run\";a:0:{}s:7:\"options\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("6531", "_bbp_private_forums", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6532", "_bbp_hidden_forums", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("240", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("195", "fusion_core_version", "5.3.1", "yes");
INSERT INTO `wp_options` VALUES("186", "fusion_builder_version", "3.3.1", "yes");
INSERT INTO `wp_options` VALUES("184", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("243", "revslider-valid-notice", "false", "yes");
INSERT INTO `wp_options` VALUES("244", "avada_revslider_version", "6.2.2", "yes");
INSERT INTO `wp_options` VALUES("204", "layerslider-purchase-code", "", "yes");
INSERT INTO `wp_options` VALUES("397", "ls-show-canceled_activation_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("205", "layerslider-authorized-site", "0", "yes");
INSERT INTO `wp_options` VALUES("206", "ls-plugin-version", "6.11.2", "yes");
INSERT INTO `wp_options` VALUES("207", "ls-db-version", "6.9.0", "yes");
INSERT INTO `wp_options` VALUES("208", "ls-installed", "1", "yes");
INSERT INTO `wp_options` VALUES("209", "ls-date-installed", "1555860848", "yes");
INSERT INTO `wp_options` VALUES("211", "fusion_supported_plugins_active", "a:6:{i:0;s:5:\"WPCF7\";i:1;s:7:\"bbPress\";i:2;s:11:\"WooCommerce\";i:3;s:19:\"Tribe__Events__Main\";i:4;s:17:\"LS_PLUGIN_VERSION\";i:5;s:14:\"RS_PLUGIN_PATH\";}", "yes");
INSERT INTO `wp_options` VALUES("222", "revslider-valid", "false", "yes");
INSERT INTO `wp_options` VALUES("223", "revslider-code", "NULLED-BY-GANJAPARKER", "yes");
INSERT INTO `wp_options` VALUES("224", "revslider-temp-active-notice", "false", "yes");
INSERT INTO `wp_options` VALUES("225", "revslider_servers", "a:7:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-b.tools\";i:3;s:22:\"themepunch-ext-b.tools\";i:4;s:22:\"themepunch-ext-b.tools\";i:5;s:16:\"themepunch.tools\";i:6;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("233", "revslider-library-check", "1622904729", "yes");
INSERT INTO `wp_options` VALUES("234", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("226", "revslider_server_refresh", "1622785266", "yes");
INSERT INTO `wp_options` VALUES("227", "revslider-update-check-short", "1622904729", "yes");
INSERT INTO `wp_options` VALUES("228", "revslider-templates-check", "1622904729", "yes");
INSERT INTO `wp_options` VALUES("164", "shop_catalog_image_size", "a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}", "yes");
INSERT INTO `wp_options` VALUES("165", "shop_single_image_size", "a:3:{s:5:\"width\";i:700;s:6:\"height\";s:0:\"\";i:0;i:0;}", "yes");
INSERT INTO `wp_options` VALUES("166", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";i:120;s:6:\"height\";s:0:\"\";i:0;i:0;}", "yes");
INSERT INTO `wp_options` VALUES("167", "woocommerce_single_image_width", "700", "yes");
INSERT INTO `wp_options` VALUES("168", "woocommerce_thumbnail_image_width", "500", "yes");
INSERT INTO `wp_options` VALUES("169", "woocommerce_thumbnail_cropping", "uncropped", "yes");
INSERT INTO `wp_options` VALUES("170", "fusion_dynamic_css_posts", "a:1:{i:10709;b:1;}", "yes");
INSERT INTO `wp_options` VALUES("171", "fusion_dynamic_css_ids", "a:1:{i:10709;s:32:\"5d6e9a90cdc6891b771e1eeb512cbe8e\";}", "yes");
INSERT INTO `wp_options` VALUES("8643", "tribe_last_generate_rewrite_rules", "1622906252.2042", "yes");
INSERT INTO `wp_options` VALUES("8628", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"XqtoDWxNjfmFwanyVU8IjTKvjRH2kcZ3\";}", "yes");
INSERT INTO `wp_options` VALUES("8629", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("8630", "tribe_last_updated_option", "1622906393.8579", "yes");
INSERT INTO `wp_options` VALUES("28455", "fusion_core_flush_permalinks", "1", "yes");
INSERT INTO `wp_options` VALUES("28463", "_site_transient_timeout_fusion_patches", "1622907243", "no");
INSERT INTO `wp_options` VALUES("28464", "_site_transient_fusion_patches", "a:4:{s:5:\"avada\";O:8:\"stdClass\":1:{s:6:\"418984\";O:8:\"stdClass\":4:{s:4:\"date\";s:13:\"May. 14, 2021\";s:11:\"description\";s:116:\"<p>Fixes PHP notice and request loop when custom icons package is missing and preloading icon fonts is enabled.</p>\n\";s:8:\"versions\";a:1:{i:0;s:5:\"7.3.1\";}s:5:\"patch\";a:2:{i:0;O:8:\"stdClass\":4:{s:7:\"context\";s:5:\"avada\";s:7:\"version\";s:5:\"7.3.1\";s:4:\"path\";s:54:\"includes/lib/inc/custom-icons/custom-icons-helpers.php\";s:9:\"reference\";s:108:\"aHR0cHM6Ly91cGRhdGVzLnRoZW1lLWZ1c2lvbi5jb20vYXZhZGFfcGF0Y2gvP2FjdGlvbj1zZXJ2ZV9maWxlJmlkPTQxODk4NCZrZXk9MA==\";}i:1;O:8:\"stdClass\":4:{s:7:\"context\";s:5:\"avada\";s:7:\"version\";s:5:\"7.3.1\";s:4:\"path\";s:62:\"includes/lib/inc/custom-icons/class-fusion-custom-icon-set.php\";s:9:\"reference\";s:108:\"aHR0cHM6Ly91cGRhdGVzLnRoZW1lLWZ1c2lvbi5jb20vYXZhZGFfcGF0Y2gvP2FjdGlvbj1zZXJ2ZV9maWxlJmlkPTQxODk4NCZrZXk9MQ==\";}}}}s:14:\"fusion-builder\";O:8:\"stdClass\":1:{s:6:\"418984\";O:8:\"stdClass\":4:{s:4:\"date\";s:13:\"May. 14, 2021\";s:11:\"description\";s:116:\"<p>Fixes PHP notice and request loop when custom icons package is missing and preloading icon fonts is enabled.</p>\n\";s:8:\"versions\";a:1:{i:0;s:5:\"7.3.1\";}s:5:\"patch\";a:2:{i:0;O:8:\"stdClass\":4:{s:7:\"context\";s:5:\"avada\";s:7:\"version\";s:5:\"7.3.1\";s:4:\"path\";s:54:\"includes/lib/inc/custom-icons/custom-icons-helpers.php\";s:9:\"reference\";s:108:\"aHR0cHM6Ly91cGRhdGVzLnRoZW1lLWZ1c2lvbi5jb20vYXZhZGFfcGF0Y2gvP2FjdGlvbj1zZXJ2ZV9maWxlJmlkPTQxODk4NCZrZXk9MA==\";}i:1;O:8:\"stdClass\":4:{s:7:\"context\";s:5:\"avada\";s:7:\"version\";s:5:\"7.3.1\";s:4:\"path\";s:62:\"includes/lib/inc/custom-icons/class-fusion-custom-icon-set.php\";s:9:\"reference\";s:108:\"aHR0cHM6Ly91cGRhdGVzLnRoZW1lLWZ1c2lvbi5jb20vYXZhZGFfcGF0Y2gvP2FjdGlvbj1zZXJ2ZV9maWxlJmlkPTQxODk4NCZrZXk9MQ==\";}}}}s:11:\"fusion-core\";O:8:\"stdClass\":1:{s:6:\"418984\";O:8:\"stdClass\":4:{s:4:\"date\";s:13:\"May. 14, 2021\";s:11:\"description\";s:116:\"<p>Fixes PHP notice and request loop when custom icons package is missing and preloading icon fonts is enabled.</p>\n\";s:8:\"versions\";a:1:{i:0;s:5:\"7.3.1\";}s:5:\"patch\";a:2:{i:0;O:8:\"stdClass\":4:{s:7:\"context\";s:5:\"avada\";s:7:\"version\";s:5:\"7.3.1\";s:4:\"path\";s:54:\"includes/lib/inc/custom-icons/custom-icons-helpers.php\";s:9:\"reference\";s:108:\"aHR0cHM6Ly91cGRhdGVzLnRoZW1lLWZ1c2lvbi5jb20vYXZhZGFfcGF0Y2gvP2FjdGlvbj1zZXJ2ZV9maWxlJmlkPTQxODk4NCZrZXk9MA==\";}i:1;O:8:\"stdClass\":4:{s:7:\"context\";s:5:\"avada\";s:7:\"version\";s:5:\"7.3.1\";s:4:\"path\";s:62:\"includes/lib/inc/custom-icons/class-fusion-custom-icon-set.php\";s:9:\"reference\";s:108:\"aHR0cHM6Ly91cGRhdGVzLnRoZW1lLWZ1c2lvbi5jb20vYXZhZGFfcGF0Y2gvP2FjdGlvbj1zZXJ2ZV9maWxlJmlkPTQxODk4NCZrZXk9MQ==\";}}}}s:27:\"fusion-white-label-branding\";O:8:\"stdClass\":1:{s:6:\"418984\";O:8:\"stdClass\":4:{s:4:\"date\";s:13:\"May. 14, 2021\";s:11:\"description\";s:116:\"<p>Fixes PHP notice and request loop when custom icons package is missing and preloading icon fonts is enabled.</p>\n\";s:8:\"versions\";a:1:{i:0;s:5:\"7.3.1\";}s:5:\"patch\";a:2:{i:0;O:8:\"stdClass\":4:{s:7:\"context\";s:5:\"avada\";s:7:\"version\";s:5:\"7.3.1\";s:4:\"path\";s:54:\"includes/lib/inc/custom-icons/custom-icons-helpers.php\";s:9:\"reference\";s:108:\"aHR0cHM6Ly91cGRhdGVzLnRoZW1lLWZ1c2lvbi5jb20vYXZhZGFfcGF0Y2gvP2FjdGlvbj1zZXJ2ZV9maWxlJmlkPTQxODk4NCZrZXk9MA==\";}i:1;O:8:\"stdClass\":4:{s:7:\"context\";s:5:\"avada\";s:7:\"version\";s:5:\"7.3.1\";s:4:\"path\";s:62:\"includes/lib/inc/custom-icons/class-fusion-custom-icon-set.php\";s:9:\"reference\";s:108:\"aHR0cHM6Ly91cGRhdGVzLnRoZW1lLWZ1c2lvbi5jb20vYXZhZGFfcGF0Y2gvP2FjdGlvbj1zZXJ2ZV9maWxlJmlkPTQxODk4NCZrZXk9MQ==\";}}}}}", "no");
INSERT INTO `wp_options` VALUES("28465", "_site_transient_timeout_fusion_patcher_check_num", "1622991843", "no");
INSERT INTO `wp_options` VALUES("28466", "_site_transient_fusion_patcher_check_num", "a:1:{s:5:\"avada\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("28467", "bsf_analytics_installed_time", "1622905443", "no");
INSERT INTO `wp_options` VALUES("28468", "_transient_avada_dashboard_data", "a:5:{s:7:\"on_sale\";b:0;s:5:\"price\";s:3:\"$60\";s:9:\"video_url\";s:43:\"https://www.youtube.com/watch?v=XSwWmXmC9Lg\";s:13:\"avada_version\";s:5:\"7.3.1\";s:13:\"bypass_active\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("235", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("236", "rs_tables_created", "1", "yes");
INSERT INTO `wp_options` VALUES("237", "revslider_table_version", "1.0.8", "yes");
INSERT INTO `wp_options` VALUES("238", "revslider-global-settings", "{\"version\":\"6.2.0\",\"permission\":\"admin\",\"includeids\":\"\",\"script\":{\"footer\":false,\"defer\":false,\"full\":false},\"fonturl\":\"\",\"size\":{\"desktop\":1240,\"notebook\":1024,\"tablet\":778,\"mobile\":480}}", "yes");
INSERT INTO `wp_options` VALUES("239", "revslider_update_version", "6.2.0", "yes");
INSERT INTO `wp_options` VALUES("250", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.4.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";d:1555873546;s:7:\"version\";s:5:\"5.1.1\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("281", "fusion_dynamic_css_time", "1622905451", "yes");
INSERT INTO `wp_options` VALUES("335", "avada_disable_encoding", "1", "yes");
INSERT INTO `wp_options` VALUES("287", "_transient_timeout_fusion_dynamic_css_6ffd72c10f5f88370fcb0c5c47e56559", "1555864881", "no");
INSERT INTO `wp_options` VALUES("1696", "ls-store-last-updated", "1559838702", "yes");
INSERT INTO `wp_options` VALUES("1697", "ls-store-data", "a:2:{s:12:\"last_updated\";s:10:\"2017-12-22\";s:7:\"sliders\";a:74:{s:20:\"catering-xmas-slider\";a:7:{s:8:\"released\";s:10:\"2017-12-22\";s:4:\"name\";s:25:\"Catering Christmas Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:29:\"premium,new,static,text,blend\";s:3:\"url\";s:72:\"https://layerslider.kreaturamedia.com/sliders/catering-christmas-slider/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/catering-xmas-slider.jpg\";}s:20:\"discover-the-details\";a:7:{s:8:\"released\";s:10:\"2017-12-19\";s:4:\"name\";s:20:\"Discover the Details\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:50:\"premium,new,loop,parallax,blendmode,specialeffects\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/discover-the-details/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/discover-the-details.jpg\";}s:10:\"rainforest\";a:7:{s:8:\"released\";s:10:\"2017-12-17\";s:4:\"name\";s:10:\"Rainforest\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:48:\"premium,new,loop,filter,blendmode,specialeffects\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/rainforest/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/rainforest.jpg\";}s:30:\"ecommerce-global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-12-15\";s:4:\"name\";s:30:\"eCommerce Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:23:\"premium,new,experiments\";s:3:\"url\";s:77:\"https://layerslider.kreaturamedia.com/sliders/ecommerce-global-hover-example/\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce-global-hover-example.jpg\";}s:20:\"3d-canyon-experience\";a:7:{s:8:\"released\";s:10:\"2017-12-13\";s:4:\"name\";s:20:\"3D Canyon Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:37:\"premium,new,parallax,experiments,text\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/3d-canyon-experience/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/3d-canyon-experience.jpg\";}s:14:\"discount-popup\";a:7:{s:8:\"released\";s:10:\"2017-12-10\";s:4:\"name\";s:14:\"Discount Popup\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:21:\"premium,premium,popup\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/discount-popup/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/discount-popup.jpg\";}s:14:\"vintage-photos\";a:7:{s:8:\"released\";s:10:\"2017-12-08\";s:4:\"name\";s:14:\"Vintage Photos\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:47:\"premium,new,fullsize,loop,filter,specialeffects\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/vintage-photos/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/vintage-photos.jpg\";}s:18:\"social-share-popup\";a:7:{s:8:\"released\";s:10:\"2017-12-06\";s:4:\"name\";s:18:\"Social Share Popup\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:21:\"premium,new,popup,api\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/social-share-popup/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/social-share-popup.jpg\";}s:8:\"aquarium\";a:7:{s:8:\"released\";s:10:\"2017-12-04\";s:4:\"name\";s:8:\"Aquarium\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:59:\"premium,new,parallax,loop,filter,experiments,specialeffects\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/aquarium/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/aquarium.jpg\";}s:16:\"what-is-the-time\";a:7:{s:8:\"released\";s:10:\"2017-08-25\";s:4:\"name\";s:17:\"What is the time?\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:51:\"premium,new,parallax,text,blendmode,experiments,api\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/what-is-the-time/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/what-is-the-time.jpg\";}s:18:\"personal-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-23\";s:4:\"name\";s:18:\"Personal Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:58:\"premium,new,fullsize,fullwidth,landing,text,parallax,packs\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/personal-page-pack/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/personal-page-pack.jpg\";}s:19:\"marketing-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-21\";s:4:\"name\";s:19:\"Marketing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:65:\"premium,new,fullsize,fullwidth,landing,parallax,static,loop,packs\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/marketing-page-pack/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/marketing-page-pack.jpg\";}s:14:\"dynamic-slider\";a:7:{s:8:\"released\";s:10:\"2017-08-18\";s:4:\"name\";s:14:\"Dynamic Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:36:\"premium,new,fullwidth,landing,static\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/dynamic-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-slider.jpg\";}s:14:\"colorful-cases\";a:7:{s:8:\"released\";s:10:\"2017-08-16\";s:4:\"name\";s:14:\"Colorful Cases\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:47:\"premium,new,text,loop,parallax,static,blendmode\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/colorful-cases/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/colorful-cases.jpg\";}s:16:\"beauty-shop-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-14\";s:4:\"name\";s:16:\"Beauty Shop PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:40:\"premium,new,fullwidth,text,landing,packs\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/beauty-shop-pack/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beauty-shop-pack.jpg\";}s:16:\"popup-guide-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Guide Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:31:\"premium,new,popup,parallax,text\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/popup-guide-demo/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-guide-demo.jpg\";}s:18:\"popup-welcome-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Welcome Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:31:\"premium,new,popup,parallax,text\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/popup-welcome-demo/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-welcome-demo.jpg\";}s:22:\"popup-transparent-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:22:\"Popup Transparent Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:31:\"premium,new,popup,parallax,loop\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/sliders/popup-transparent-demo/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-transparent-demo.jpg\";}s:18:\"popup-sidebar-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Sidebar Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:40:\"premium,popup,experiments,blendmode,text\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/popup-sidebar-demo/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-sidebar-demo.jpg\";}s:19:\"popup-photo-gallery\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:19:\"Popup Photo Gallery\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:26:\"premium,new,popup,kenburns\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/popup-photo-gallery/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-photo-gallery.jpg\";}s:16:\"popup-modal-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Modal Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:24:\"premium,new,popup,static\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/popup-modal-demo/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-modal-demo.jpg\";}s:18:\"popup-infobar-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Infobar Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:34:\"premium,new,popup,experiments,text\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/popup-infobar-demo/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-infobar-demo.jpg\";}s:24:\"popup-fullsize-desk-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:24:\"Popup Fullsize Desk Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:47:\"premium,new,popup,experiments,fullsize,parallax\";s:3:\"url\";s:71:\"https://layerslider.kreaturamedia.com/sliders/popup-fullsize-desk-demo/\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-fullsize-desk-demo.jpg\";}s:18:\"conversation-popup\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Conversation Popup\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:29:\"premium,new,popup,experiments\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/conversation-popup/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/conversation-popup.jpg\";}s:20:\"global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-05-02\";s:4:\"name\";s:20:\"Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.4.0\";s:6:\"groups\";s:52:\"premium,new,experiments,specialeffects,parallax,text\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/global-hover-example/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/global-hover-example.jpg\";}s:10:\"gastronomy\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:10:\"Gastronomy\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:28:\"premium,kenburns,filter,text\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/gastronomy/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/gastronomy.jpg\";}s:13:\"police-lights\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:13:\"Police Lights\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:46:\"premium,specialeffects,loop,blendmode,parallax\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/police-lights/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/police-lights.jpg\";}s:16:\"beautiful-sunset\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Beautiful Sunset\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:37:\"premium,specialeffects,loop,blendmode\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/beautiful-sunset/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beautiful-sunset.jpg\";}s:23:\"blend-mode-experiment-1\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:23:\"Blend Mode Experiment 1\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:63:\"premium,specialeffects,text,blendmode,experiments,loop,parallax\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/sliders/blend-mode-experiment-1/\";s:7:\"preview\";s:84:\"https://repository.kreaturamedia.com/v4/sliders/packages/blend-mode-experiment-1.jpg\";}s:16:\"flying-banners-2\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Flying Banners 2\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:40:\"premium,parallax,specialeffects,fullsize\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/flying-banners-2/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-2.jpg\";}s:14:\"layerslider-v6\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:14:\"LayerSlider v6\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.6\";s:6:\"groups\";s:68:\"premium,specialeffects,parallax,fullsize,landing,loop,text,media,api\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/layerslider-v6/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/layerslider-v6.jpg\";}s:16:\"flying-banners-1\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:16:\"Flying Banners 1\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:38:\"free,parallax,loop,text,specialeffects\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/flying-banners-1/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-1.jpg\";}s:18:\"anniversary-slider\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:18:\"Anniversary Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:40:\"free,parallax,experiments,specialeffects\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/anniversary-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/anniversary-slider.jpg\";}s:7:\"origami\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:7:\"Origami\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:47:\"premium,experiments,specialeffects,3dtransition\";s:3:\"url\";s:54:\"https://layerslider.kreaturamedia.com/sliders/origami/\";s:7:\"preview\";s:68:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami.jpg\";}s:17:\"origami-buildings\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:17:\"Origami Buildings\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:56:\"premium,experiments,specialeffects,kenburns,3dtransition\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/origami-buildings/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami-buildings.jpg\";}s:17:\"autumn-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:17:\"Autumn Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:45:\"experiments,free,loop,parallax,specialeffects\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/autumn-experiment/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/autumn-experiment.jpg\";}s:28:\"features-parallax-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:32:\"Features | A Parallax Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:40:\"experiments,free,parallax,specialeffects\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/sliders/features-parallax-experiment/\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/features-parallax-experiment.jpg\";}s:16:\"furniture-slider\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:16:\"Furniture Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:33:\"fullwidth,parallax,premium,static\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/furniture-slider/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/furniture-slider.jpg\";}s:15:\"room-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:15:\"Room Experiment\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.6\";s:6:\"groups\";s:65:\"api,experiments,media,parallax,premium,specialeffects,static,text\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/room-experiment/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/room-experiment.jpg\";}s:11:\"drag-n-drop\";a:6:{s:4:\"name\";s:11:\"Drag & Drop\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:37:\"premium,fullwidth,specialeffects,text\";s:3:\"url\";s:58:\"https://layerslider.kreaturamedia.com/sliders/drag-n-drop/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/drag-n-drop.jpg\";}s:10:\"headphones\";a:6:{s:4:\"name\";s:10:\"Headphones\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:14:\"premium,static\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/headphones/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/headphones.jpg\";}s:14:\"play-by-scroll\";a:6:{s:4:\"name\";s:19:\"Play By Scroll demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:66:\"premium,fullsize,text,experiments,specialeffects,playbyscroll,loop\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/play-by-scroll/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/play-by-scroll.jpg\";}s:3:\"sky\";a:6:{s:4:\"name\";s:14:\"Sky Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:63:\"premium,fullwidth,text,experiments,parallax,specialeffects,loop\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/sky-experience/\";s:7:\"preview\";s:64:\"https://repository.kreaturamedia.com/v4/sliders/packages/sky.jpg\";}s:9:\"halloween\";a:6:{s:4:\"name\";s:16:\"Happy Halloween!\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:35:\"free,fullsize,text,experiments,loop\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/happy-halloween/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/halloween.jpg\";}s:15:\"creative-agency\";a:6:{s:4:\"name\";s:6:\"Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:49:\"premium,fullsize,kenburns,parallax,landing,filter\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/creative-agency/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/creative-agency.jpg\";}s:18:\"interactive-slider\";a:6:{s:4:\"name\";s:18:\"Interactive Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:47:\"premium,fullsize,parallax,kenburns,text,landing\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/interactive-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/interactive-slider.jpg\";}s:9:\"ecommerce\";a:6:{s:4:\"name\";s:9:\"eCommerce\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:56:\"https://layerslider.kreaturamedia.com/sliders/ecommerce/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce.jpg\";}s:18:\"landing-page-intro\";a:6:{s:4:\"name\";s:18:\"Landing Page Intro\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:38:\"premium,fullsize,landing,parallax,text\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/landing-page/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-page-intro.jpg\";}s:6:\"hiking\";a:6:{s:4:\"name\";s:6:\"Hiking\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:53:\"https://layerslider.kreaturamedia.com/sliders/hiking/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/hiking.jpg\";}s:12:\"movie-slider\";a:6:{s:4:\"name\";s:12:\"Movie Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/movie-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/movie-slider.jpg\";}s:12:\"photo-studio\";a:6:{s:4:\"name\";s:12:\"Photo Studio\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:62:\"premium,fullsize,filter,text,parallax,specialeffects,blendmode\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/photo-studio/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/photo-studio.jpg\";}s:5:\"shoes\";a:6:{s:4:\"name\";s:5:\"Shoes\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:35:\"premium,fullwidth,parallax,carousel\";s:3:\"url\";s:52:\"https://layerslider.kreaturamedia.com/sliders/shoes/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/shoes.jpg\";}s:11:\"mini-cooper\";a:6:{s:4:\"name\";s:18:\"Mini Cooper Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:40:\"premium,fullsize,parallax,specialeffects\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/mini-cooper-slider/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/mini-cooper.jpg\";}s:4:\"xmas\";a:6:{s:4:\"name\";s:16:\"Merry Christmas!\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:60:\"premium,parallax,filter,experiments,specialeffects,text,loop\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/merry-christmas/\";s:7:\"preview\";s:65:\"https://repository.kreaturamedia.com/v4/sliders/packages/xmas.jpg\";}s:5:\"clock\";a:6:{s:4:\"name\";s:32:\"Vintage Clock | shows valid time\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:37:\"premium,fullsize,api,experiments,loop\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/vintage-clock/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/clock.jpg\";}s:8:\"car-show\";a:6:{s:4:\"name\";s:8:\"Car Show\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:38:\"premium,fullwidth,experiments,api,loop\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/car-show/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/car-show.jpg\";}s:16:\"landing-screen-1\";a:6:{s:4:\"name\";s:16:\"Landing Screen 1\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:34:\"premium,fullwidth,landing,parallax\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/landing-screen-1/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-screen-1.jpg\";}s:16:\"landing-screen-2\";a:6:{s:4:\"name\";s:16:\"Landing Screen 2\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:25:\"premium,fullwidth,landing\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/landing-screen-2/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-screen-2.jpg\";}s:16:\"landing-screen-3\";a:6:{s:4:\"name\";s:16:\"Landing Screen 3\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:34:\"premium,fullwidth,landing,parallax\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/landing-screen-3/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-screen-3.jpg\";}s:16:\"landing-screen-4\";a:6:{s:4:\"name\";s:16:\"Landing Screen 4\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:34:\"premium,fullwidth,landing,parallax\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/landing-screen-4/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-screen-4.jpg\";}s:16:\"landing-screen-5\";a:6:{s:4:\"name\";s:16:\"Landing Screen 5\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:25:\"premium,fullwidth,landing\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/landing-screen-5/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-screen-5.jpg\";}s:16:\"landing-screen-6\";a:6:{s:4:\"name\";s:16:\"Landing Screen 6\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:25:\"premium,fullwidth,landing\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/landing-screen-6/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-screen-6.jpg\";}s:16:\"landing-screen-7\";a:6:{s:4:\"name\";s:16:\"Landing Screen 7\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:25:\"premium,fullwidth,landing\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/landing-screen-7/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-screen-7.jpg\";}s:8:\"carousel\";a:6:{s:4:\"name\";s:8:\"Carousel\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:13:\"free,carousel\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/carousel/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/carousel.jpg\";}s:14:\"fancy-parallax\";a:6:{s:4:\"name\";s:21:\"Fancy Parallax Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:26:\"premium,fullwidth,parallax\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/parallax-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/fancy-parallax.jpg\";}s:13:\"simple-slider\";a:6:{s:4:\"name\";s:13:\"Simple Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:4:\"free\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/simple-slider/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/simple-slider.jpg\";}s:12:\"image-slider\";a:6:{s:4:\"name\";s:12:\"Image Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:4:\"free\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/image-slideshow/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/image-slider.jpg\";}s:19:\"client-testimonials\";a:6:{s:4:\"name\";s:19:\"Client Testimonials\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/client-testimonials/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/client-testimonials.jpg\";}s:8:\"fixed-bg\";a:6:{s:4:\"name\";s:16:\"Fixed Background\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:23:\"premium,fullwidth,media\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/fixed-background/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/fixed-bg.jpg\";}s:22:\"dynamic-content-slider\";a:6:{s:4:\"name\";s:22:\"Dynamic Content Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:4:\"free\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/sliders/dynamic-content-slider/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-content-slider.jpg\";}s:6:\"old-3d\";a:6:{s:4:\"name\";s:14:\"LayerSlider v4\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:23:\"free,3dtransition,media\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/3d-demo-slider/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/old-3d.jpg\";}s:2:\"v5\";a:6:{s:4:\"name\";s:14:\"LayerSlider v5\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:19:\"free,parallax,media\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/layerslider-v5/\";s:7:\"preview\";s:63:\"https://repository.kreaturamedia.com/v4/sliders/packages/v5.jpg\";}s:12:\"video-slider\";a:6:{s:4:\"name\";s:12:\"Video Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:10:\"free,media\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/video-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/video-slider.jpg\";}s:6:\"resort\";a:6:{s:4:\"name\";s:6:\"Resort\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:54:\"https://layerslider.kreaturamedia.com/sliders/restort/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/resort.jpg\";}}}", "no");
INSERT INTO `wp_options` VALUES("1698", "layerslider-gdpr-consent", "1", "yes");
INSERT INTO `wp_options` VALUES("1699", "layerslider-google-fonts-enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("1700", "layerslider-aviary-enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("259", "fusion_demo_history", "a:1:{s:7:\"classic\";a:13:{s:5:\"terms\";a:30:{i:0;a:2:{s:7:\"term_id\";i:2;s:8:\"taxonomy\";s:8:\"category\";}i:1;a:2:{s:7:\"term_id\";i:3;s:8:\"taxonomy\";s:8:\"category\";}i:2;a:2:{s:7:\"term_id\";i:4;s:8:\"taxonomy\";s:8:\"category\";}i:3;a:2:{s:7:\"term_id\";i:5;s:8:\"taxonomy\";s:8:\"category\";}i:4;a:2:{s:7:\"term_id\";i:6;s:8:\"taxonomy\";s:8:\"post_tag\";}i:5;a:2:{s:7:\"term_id\";i:7;s:8:\"taxonomy\";s:8:\"post_tag\";}i:6;a:2:{s:7:\"term_id\";i:8;s:8:\"taxonomy\";s:8:\"post_tag\";}i:7;a:2:{s:7:\"term_id\";i:9;s:8:\"taxonomy\";s:8:\"post_tag\";}i:8;a:2:{s:7:\"term_id\";i:10;s:8:\"taxonomy\";s:8:\"post_tag\";}i:9;a:2:{s:7:\"term_id\";i:11;s:8:\"taxonomy\";s:8:\"post_tag\";}i:10;a:2:{s:7:\"term_id\";i:12;s:8:\"taxonomy\";s:8:\"post_tag\";}i:11;a:2:{s:7:\"term_id\";i:13;s:8:\"taxonomy\";s:16:\"portfolio_skills\";}i:12;a:2:{s:7:\"term_id\";i:14;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:13;a:2:{s:7:\"term_id\";i:15;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:14;a:2:{s:7:\"term_id\";i:16;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:15;a:2:{s:7:\"term_id\";i:17;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:16;a:2:{s:7:\"term_id\";i:18;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:17;a:2:{s:7:\"term_id\";i:19;s:8:\"taxonomy\";s:12:\"faq_category\";}i:18;a:2:{s:7:\"term_id\";i:20;s:8:\"taxonomy\";s:21:\"themefusion_es_groups\";}i:19;a:2:{s:7:\"term_id\";i:21;s:8:\"taxonomy\";s:16:\"portfolio_skills\";}i:20;a:2:{s:7:\"term_id\";i:22;s:8:\"taxonomy\";s:16:\"portfolio_skills\";}i:21;a:2:{s:7:\"term_id\";i:23;s:8:\"taxonomy\";s:12:\"faq_category\";}i:22;a:2:{s:7:\"term_id\";i:24;s:8:\"taxonomy\";s:12:\"faq_category\";}i:23;a:2:{s:7:\"term_id\";i:25;s:8:\"taxonomy\";s:12:\"faq_category\";}i:24;a:2:{s:7:\"term_id\";i:26;s:8:\"taxonomy\";s:16:\"portfolio_skills\";}i:25;a:2:{s:7:\"term_id\";i:27;s:8:\"taxonomy\";s:16:\"portfolio_skills\";}i:26;a:2:{s:7:\"term_id\";i:28;s:8:\"taxonomy\";s:8:\"nav_menu\";}i:27;a:2:{s:7:\"term_id\";i:29;s:8:\"taxonomy\";s:8:\"nav_menu\";}i:28;a:2:{s:7:\"term_id\";i:30;s:8:\"taxonomy\";s:8:\"nav_menu\";}i:29;a:2:{s:7:\"term_id\";i:31;s:8:\"taxonomy\";s:8:\"nav_menu\";}}s:14:\"fusion_sliders\";a:6:{i:0;a:2:{s:7:\"term_id\";i:32;s:8:\"taxonomy\";s:10:\"slide-page\";}i:1;a:2:{s:7:\"term_id\";i:33;s:8:\"taxonomy\";s:10:\"slide-page\";}i:2;a:2:{s:7:\"term_id\";i:34;s:8:\"taxonomy\";s:10:\"slide-page\";}i:3;a:2:{s:7:\"term_id\";i:35;s:8:\"taxonomy\";s:10:\"slide-page\";}i:4;a:2:{s:7:\"term_id\";i:36;s:8:\"taxonomy\";s:10:\"slide-page\";}i:5;a:2:{s:7:\"term_id\";i:37;s:8:\"taxonomy\";s:10:\"slide-page\";}}s:13:\"layer_sliders\";a:4:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;}s:11:\"rev_sliders\";a:4:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;}s:13:\"theme_options\";b:0;s:7:\"widgets\";a:30:{i:0;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"149\";s:11:\"option_name\";s:24:\"widget_ad_125_125-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:1;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"100\";s:11:\"option_name\";s:15:\"widget_archives\";s:12:\"option_value\";s:94:\"a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:2;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"159\";s:11:\"option_name\";s:33:\"widget_avada-vertical-menu-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:3;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"104\";s:11:\"option_name\";s:15:\"widget_calendar\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:4;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"78\";s:11:\"option_name\";s:17:\"widget_categories\";s:12:\"option_value\";s:118:\"a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:5;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"151\";s:11:\"option_name\";s:26:\"widget_contact_info-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:6;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"111\";s:11:\"option_name\";s:18:\"widget_custom_html\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:7;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"157\";s:11:\"option_name\";s:27:\"widget_facebook-like-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:8;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"155\";s:11:\"option_name\";s:20:\"widget_flickr-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:9;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"150\";s:11:\"option_name\";s:27:\"widget_fusion_author-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:10;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"212\";s:11:\"option_name\";s:25:\"widget_layerslider_widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:11;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"105\";s:11:\"option_name\";s:18:\"widget_media_audio\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:12;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"107\";s:11:\"option_name\";s:20:\"widget_media_gallery\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:13;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"106\";s:11:\"option_name\";s:18:\"widget_media_image\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:14;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"108\";s:11:\"option_name\";s:18:\"widget_media_video\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:15;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"158\";s:11:\"option_name\";s:18:\"widget_menu-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:16;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"101\";s:11:\"option_name\";s:11:\"widget_meta\";s:12:\"option_value\";s:59:\"a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:17;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"110\";s:11:\"option_name\";s:15:\"widget_nav_menu\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:18;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"103\";s:11:\"option_name\";s:12:\"widget_pages\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:19;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"152\";s:11:\"option_name\";s:23:\"widget_pyre_tabs-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:20;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"153\";s:11:\"option_name\";s:26:\"widget_recent_works-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:21;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"99\";s:11:\"option_name\";s:22:\"widget_recent-comments\";s:12:\"option_value\";s:76:\"a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:22;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"98\";s:11:\"option_name\";s:19:\"widget_recent-posts\";s:12:\"option_value\";s:76:\"a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:23;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"240\";s:11:\"option_name\";s:24:\"widget_rev-slider-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:24;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"80\";s:11:\"option_name\";s:10:\"widget_rss\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:25;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"97\";s:11:\"option_name\";s:13:\"widget_search\";s:12:\"option_value\";s:59:\"a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:26;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"156\";s:11:\"option_name\";s:26:\"widget_social_links-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:27;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"109\";s:11:\"option_name\";s:16:\"widget_tag_cloud\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:28;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"79\";s:11:\"option_name\";s:11:\"widget_text\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:29;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"154\";s:11:\"option_name\";s:20:\"widget_tweets-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}}s:16:\"sidebars_widgets\";a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:21:\"avada-footer-widget-1\";a:0:{}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";a:0:{}s:21:\"avada-footer-widget-4\";a:0:{}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:25:\"avada-slidingbar-widget-3\";a:0:{}s:25:\"avada-slidingbar-widget-4\";a:0:{}s:13:\"array_version\";i:3;}s:12:\"sbg_sidebars\";b:0;s:8:\"blogname\";s:43:\"قالب آوادا وردپرس باران\";s:13:\"page_on_front\";s:1:\"0\";s:13:\"show_on_front\";s:5:\"posts\";s:18:\"nav_menu_locations\";a:0:{}s:12:\"general_data\";s:8:\"imported\";}}", "no");
INSERT INTO `wp_options` VALUES("260", "fusion_import_data", "a:13:{s:4:\"post\";a:1:{i:0;s:7:\"classic\";}s:4:\"page\";a:1:{i:0;s:7:\"classic\";}s:15:\"avada_portfolio\";a:1:{i:0;s:7:\"classic\";}s:9:\"avada_faq\";a:1:{i:0;s:7:\"classic\";}s:10:\"attachment\";a:1:{i:0;s:7:\"classic\";}s:7:\"product\";a:0:{}s:5:\"event\";a:0:{}s:5:\"forum\";a:0:{}s:7:\"sliders\";a:1:{i:0;s:7:\"classic\";}s:7:\"widgets\";a:1:{i:0;s:7:\"classic\";}s:13:\"theme_options\";a:1:{i:0;s:7:\"classic\";}s:12:\"general_data\";a:1:{i:0;s:7:\"classic\";}s:3:\"all\";a:1:{i:0;s:7:\"classic\";}}", "no");
INSERT INTO `wp_options` VALUES("545", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("570", "portfolio_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4768", "portfolio_skills_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3138", "faq_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("274", "slide-page_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("275", "element_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("276", "template_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("277", "ls-google-fonts", "a:3:{i:0;a:2:{s:5:\"param\";s:28:\"Lato:100,300,regular,700,900\";s:5:\"admin\";b:0;}i:1;a:2:{s:5:\"param\";s:13:\"Open+Sans:300\";s:5:\"admin\";b:0;}i:2;a:2:{s:5:\"param\";s:20:\"Indie+Flower:regular\";s:5:\"admin\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("278", "fusion_options", "a:1025:{s:8:\"last_tab\";s:0:\"\";s:6:\"layout\";s:4:\"wide\";s:10:\"site_width\";s:6:\"1100px\";s:13:\"margin_offset\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";}s:13:\"scroll_offset\";s:4:\"full\";s:18:\"boxed_modal_shadow\";s:4:\"none\";s:12:\"main_padding\";a:2:{s:3:\"top\";s:4:\"55px\";s:6:\"bottom\";s:4:\"40px\";}s:16:\"hundredp_padding\";s:4:\"30px\";s:13:\"sidebar_width\";s:3:\"23%\";s:14:\"sidebar_gutter\";s:4:\"80px\";s:17:\"sidebar_2_1_width\";s:3:\"19%\";s:17:\"sidebar_2_2_width\";s:3:\"19%\";s:19:\"dual_sidebar_gutter\";s:4:\"40px\";s:10:\"responsive\";s:1:\"1\";s:21:\"grid_main_break_point\";s:4:\"1099\";s:23:\"side_header_break_point\";s:4:\"1100\";s:19:\"content_break_point\";s:3:\"800\";s:19:\"sidebar_break_point\";s:3:\"800\";s:11:\"mobile_zoom\";s:1:\"1\";s:21:\"typography_responsive\";s:1:\"1\";s:22:\"typography_sensitivity\";d:0.54000000000000003552713678800500929355621337890625;s:17:\"typography_factor\";s:3:\"1.5\";s:13:\"primary_color\";s:7:\"#a0ce4e\";s:15:\"header_position\";s:3:\"top\";s:13:\"header_layout\";s:2:\"v1\";s:15:\"slider_position\";s:5:\"below\";s:19:\"header_left_content\";s:12:\"contact_info\";s:20:\"header_right_content\";s:10:\"navigation\";s:17:\"header_v4_content\";s:18:\"tagline_and_search\";s:13:\"header_number\";s:28:\"Call Us Today! 1.555.555.555\";s:12:\"header_email\";s:19:\"info@yourdomain.com\";s:14:\"header_tagline\";s:20:\"Insert Headline Here\";s:18:\"header_banner_code\";s:0:\"\";s:15:\"header_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"header_bg_full\";s:1:\"0\";s:18:\"header_bg_parallax\";s:1:\"0\";s:16:\"header_bg_repeat\";s:6:\"repeat\";s:17:\"side_header_width\";s:3:\"280\";s:14:\"header_padding\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"header_shadow\";s:1:\"0\";s:16:\"header_100_width\";s:1:\"0\";s:15:\"header_bg_color\";s:7:\"#ffffff\";s:23:\"archive_header_bg_color\";s:16:\"rgb(255,255,255)\";s:19:\"header_border_color\";s:7:\"#e1e1e1\";s:19:\"header_top_bg_color\";s:7:\"#a0ce4e\";s:17:\"tagline_font_size\";s:4:\"16px\";s:18:\"tagline_font_color\";s:7:\"#747474\";s:13:\"header_sticky\";s:1:\"1\";s:20:\"header_sticky_tablet\";s:1:\"0\";s:20:\"header_sticky_mobile\";s:1:\"0\";s:23:\"header_sticky_shrinkage\";s:1:\"0\";s:26:\"header_sticky_type2_layout\";s:9:\"menu_only\";s:20:\"header_sticky_shadow\";s:1:\"1\";s:22:\"header_sticky_bg_color\";s:23:\"rgba(255,255,255,0.987)\";s:24:\"header_sticky_menu_color\";s:7:\"#333333\";s:25:\"header_sticky_nav_padding\";s:2:\"40\";s:27:\"header_sticky_nav_font_size\";s:4:\"13px\";s:10:\"nav_height\";s:2:\"86\";s:20:\"menu_highlight_style\";s:3:\"bar\";s:25:\"menu_highlight_background\";s:7:\"#a0ce4e\";s:15:\"menu_arrow_size\";a:2:{s:5:\"width\";s:4:\"23px\";s:6:\"height\";s:4:\"12px\";}s:20:\"nav_highlight_border\";s:1:\"3\";s:11:\"nav_padding\";s:2:\"40\";s:18:\"mobile_nav_padding\";s:2:\"22\";s:15:\"megamenu_shadow\";s:1:\"1\";s:28:\"main_menu_sub_menu_animation\";s:4:\"fade\";s:29:\"dropdown_menu_top_border_size\";s:1:\"3\";s:19:\"dropdown_menu_width\";s:3:\"215\";s:34:\"mainmenu_dropdown_vertical_padding\";s:1:\"9\";s:33:\"mainmenu_dropdown_display_divider\";s:1:\"1\";s:31:\"menu_display_dropdown_indicator\";s:4:\"none\";s:20:\"main_nav_search_icon\";s:1:\"1\";s:20:\"main_nav_icon_circle\";s:1:\"0\";s:25:\"main_nav_highlight_radius\";s:3:\"0px\";s:17:\"menu_sub_bg_color\";s:7:\"#edecec\";s:19:\"menu_bg_hover_color\";s:7:\"#f5f5f5\";s:18:\"menu_sub_sep_color\";s:7:\"#e3e2e3\";s:17:\"menu_h45_bg_color\";s:7:\"#ffffff\";s:14:\"nav_typography\";a:10:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:5:\"false\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"13px\";s:14:\"letter-spacing\";s:3:\"0px\";s:5:\"color\";s:7:\"#333333\";}s:22:\"menu_hover_first_color\";s:7:\"#a0ce4e\";s:15:\"menu_text_align\";s:4:\"left\";s:14:\"menu_sub_color\";s:7:\"#333333\";s:22:\"nav_dropdown_font_size\";s:4:\"13px\";s:18:\"side_nav_font_size\";s:4:\"14px\";s:26:\"flyout_menu_icon_font_size\";s:4:\"20px\";s:24:\"flyout_nav_icons_padding\";s:2:\"40\";s:22:\"flyout_menu_icon_color\";s:7:\"#333333\";s:28:\"flyout_menu_icon_hover_color\";s:7:\"#a0ce4e\";s:28:\"flyout_menu_background_color\";s:22:\"rgba(255,255,255,0.95)\";s:21:\"flyout_menu_direction\";s:4:\"fade\";s:24:\"flyout_menu_item_padding\";s:2:\"26\";s:23:\"topmenu_dropwdown_width\";s:3:\"180\";s:29:\"header_top_first_border_color\";s:7:\"#ffffff\";s:23:\"header_top_sub_bg_color\";s:7:\"#ffffff\";s:30:\"header_top_menu_bg_hover_color\";s:7:\"#fafafa\";s:29:\"header_top_menu_sub_sep_color\";s:7:\"#e0dfdf\";s:14:\"snav_font_size\";s:4:\"12px\";s:11:\"sec_menu_lh\";s:4:\"44px\";s:10:\"snav_color\";s:7:\"#ffffff\";s:25:\"header_top_menu_sub_color\";s:7:\"#333333\";s:31:\"header_top_menu_sub_hover_color\";s:7:\"#333333\";s:18:\"mobile_menu_design\";s:6:\"modern\";s:28:\"mobile_menu_icons_top_margin\";s:1:\"5\";s:22:\"mobile_menu_nav_height\";s:2:\"40\";s:27:\"mobile_nav_submenu_slideout\";s:1:\"1\";s:18:\"mobile_menu_search\";s:1:\"0\";s:29:\"mobile_menu_submenu_indicator\";s:1:\"1\";s:22:\"mobile_header_bg_color\";s:16:\"rgb(255,255,255)\";s:30:\"mobile_archive_header_bg_color\";s:16:\"rgb(255,255,255)\";s:28:\"mobile_menu_background_color\";s:7:\"#f9f9f9\";s:23:\"mobile_menu_hover_color\";s:7:\"#f6f6f6\";s:24:\"mobile_menu_border_color\";s:7:\"#dadada\";s:24:\"mobile_menu_toggle_color\";s:7:\"#dadada\";s:22:\"mobile_menu_typography\";a:11:{s:11:\"font-family\";s:7:\"PT Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"13px\";s:11:\"line-height\";s:4:\"40px\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#333333\";}s:28:\"mobile_menu_font_hover_color\";s:7:\"#333333\";s:22:\"mobile_menu_text_align\";s:4:\"left\";s:18:\"megamenu_max_width\";s:4:\"1100\";s:19:\"megamenu_title_size\";s:4:\"18px\";s:30:\"megamenu_item_vertical_padding\";s:1:\"7\";s:29:\"megamenu_item_display_divider\";s:1:\"0\";s:18:\"menu_icon_position\";s:4:\"left\";s:14:\"menu_icon_size\";s:2:\"13\";s:15:\"menu_icon_color\";s:7:\"#333333\";s:21:\"menu_icon_hover_color\";s:7:\"#a0ce4e\";s:19:\"menu_thumbnail_size\";a:2:{s:5:\"width\";s:4:\"26px\";s:6:\"height\";s:4:\"13px\";}s:14:\"logo_alignment\";s:4:\"left\";s:11:\"logo_margin\";a:4:{s:3:\"top\";s:4:\"31px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"31px\";s:4:\"left\";s:3:\"0px\";}s:15:\"logo_background\";s:1:\"0\";s:21:\"logo_background_color\";s:7:\"#a0ce4e\";s:16:\"logo_custom_link\";s:0:\"\";s:4:\"logo\";a:5:{s:3:\"url\";s:65:\"https://demo.wpbaran.ir/avada/wp-content/uploads/2016/04/logo.png\";s:2:\"id\";s:5:\"11471\";s:6:\"height\";s:2:\"24\";s:5:\"width\";s:3:\"113\";s:9:\"thumbnail\";s:65:\"https://demo.wpbaran.ir/avada/wp-content/uploads/2016/04/logo.png\";}s:11:\"logo_retina\";a:5:{s:3:\"url\";s:67:\"https://demo.wpbaran.ir/avada/wp-content/uploads/2016/09/logo2x.png\";s:2:\"id\";s:5:\"11629\";s:6:\"height\";s:2:\"48\";s:5:\"width\";s:3:\"226\";s:9:\"thumbnail\";s:67:\"https://demo.wpbaran.ir/avada/wp-content/uploads/2016/09/logo2x.png\";}s:18:\"sticky_header_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"sticky_header_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"mobile_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"mobile_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"favicon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"iphone_icon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"iphone_icon_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:9:\"ipad_icon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:16:\"ipad_icon_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"page_title_bar\";s:15:\"bar_and_content\";s:19:\"page_title_bar_text\";s:1:\"1\";s:20:\"page_title_100_width\";s:1:\"0\";s:17:\"page_title_height\";s:4:\"87px\";s:24:\"page_title_mobile_height\";s:4:\"70px\";s:19:\"page_title_bg_color\";s:7:\"#f6f6f6\";s:23:\"page_title_border_color\";s:7:\"#d2d3d4\";s:20:\"page_title_font_size\";s:4:\"18px\";s:22:\"page_title_line_height\";s:4:\"1.45\";s:16:\"page_title_color\";s:7:\"#333333\";s:30:\"page_title_subheader_font_size\";s:4:\"10px\";s:26:\"page_title_subheader_color\";s:7:\"#333333\";s:20:\"page_title_alignment\";s:4:\"left\";s:13:\"page_title_bg\";a:5:{s:3:\"url\";s:70:\"https://avada.theme-fusion.com/wp-content/uploads/2014/12/ptb_bkgd.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:2:\"87\";s:5:\"width\";s:4:\"1100\";s:9:\"thumbnail\";s:0:\"\";}s:20:\"page_title_bg_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"page_title_bg_full\";s:1:\"0\";s:22:\"page_title_bg_parallax\";s:1:\"0\";s:17:\"page_title_fading\";s:1:\"1\";s:17:\"page_title_bar_bs\";s:11:\"breadcrumbs\";s:17:\"breadcrumb_mobile\";s:1:\"0\";s:16:\"breacrumb_prefix\";s:0:\"\";s:20:\"breadcrumb_separator\";s:1:\"/\";s:21:\"breadcrumbs_font_size\";s:4:\"11px\";s:22:\"breadcrumbs_text_color\";s:7:\"#333333\";s:28:\"breadcrumbs_text_hover_color\";s:7:\"#333333\";s:26:\"breadcrumb_show_categories\";s:1:\"1\";s:33:\"breadcrumb_show_post_type_archive\";s:1:\"0\";s:18:\"slidingbar_widgets\";s:1:\"1\";s:25:\"mobile_slidingbar_widgets\";s:1:\"0\";s:23:\"slidingbar_open_on_load\";s:1:\"0\";s:19:\"slidingbar_position\";s:3:\"top\";s:16:\"slidingbar_width\";s:5:\"300px\";s:17:\"slidingbar_sticky\";s:1:\"0\";s:26:\"slidingbar_widgets_columns\";s:1:\"3\";s:27:\"slidingbar_column_alignment\";s:7:\"stacked\";s:26:\"slidingbar_content_padding\";a:4:{s:3:\"top\";s:4:\"35px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"35px\";s:4:\"left\";s:4:\"30px\";}s:24:\"slidingbar_content_align\";s:4:\"left\";s:23:\"slidingbar_toggle_style\";s:8:\"triangle\";s:19:\"slidingbar_bg_color\";s:7:\"#363839\";s:24:\"slidingbar_divider_color\";s:7:\"#505152\";s:28:\"slidingbar_toggle_icon_color\";s:7:\"#ffffff\";s:20:\"slidingbar_font_size\";s:4:\"13px\";s:25:\"slidingbar_headings_color\";s:7:\"#dddddd\";s:21:\"slidingbar_text_color\";s:7:\"#8c8989\";s:21:\"slidingbar_link_color\";s:7:\"#bfbfbf\";s:27:\"slidingbar_link_color_hover\";s:7:\"#a0ce4e\";s:17:\"slidingbar_border\";s:1:\"0\";s:14:\"footer_widgets\";s:1:\"1\";s:22:\"footer_widgets_columns\";s:1:\"4\";s:29:\"footer_widgets_center_content\";s:1:\"0\";s:22:\"footer_special_effects\";s:4:\"none\";s:16:\"footer_copyright\";s:1:\"1\";s:31:\"footer_copyright_center_content\";s:1:\"0\";s:11:\"footer_text\";s:63:\"تمامی حقوق برای این سایت محفوظ است.\";s:16:\"footerw_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"footerw_bg_full\";s:1:\"0\";s:17:\"footerw_bg_repeat\";s:6:\"repeat\";s:14:\"footerw_bg_pos\";s:8:\"top left\";s:16:\"footer_100_width\";s:1:\"0\";s:19:\"footer_area_padding\";a:4:{s:3:\"top\";s:4:\"60px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"55px\";s:4:\"left\";s:3:\"0px\";}s:15:\"footer_bg_color\";s:7:\"#363839\";s:18:\"footer_border_size\";s:2:\"12\";s:19:\"footer_border_color\";s:7:\"#e9eaee\";s:19:\"footer_divider_line\";s:1:\"0\";s:24:\"footer_divider_line_size\";s:1:\"1\";s:25:\"footer_divider_line_style\";s:5:\"solid\";s:20:\"footer_divider_color\";s:7:\"#505152\";s:22:\"footer_widgets_padding\";s:4:\"15px\";s:17:\"copyright_padding\";a:2:{s:3:\"top\";s:4:\"20px\";s:6:\"bottom\";s:4:\"20px\";}s:18:\"copyright_bg_color\";s:7:\"#282a2b\";s:21:\"copyright_border_size\";s:1:\"1\";s:22:\"copyright_border_color\";s:7:\"#4b4c4d\";s:26:\"footer_headings_typography\";a:11:{s:11:\"font-family\";s:7:\"PT Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#DDDDDD\";}s:17:\"footer_text_color\";s:7:\"#8c8989\";s:17:\"footer_link_color\";s:7:\"#bfbfbf\";s:23:\"footer_link_color_hover\";s:7:\"#a0ce4e\";s:20:\"copyright_text_color\";s:7:\"#8c8989\";s:20:\"copyright_link_color\";s:7:\"#bfbfbf\";s:26:\"copyright_link_color_hover\";s:7:\"#a0ce4e\";s:19:\"copyright_font_size\";s:4:\"12px\";s:24:\"responsive_sidebar_order\";s:25:\"content,sidebar,sidebar-2\";s:14:\"sidebar_sticky\";s:4:\"none\";s:15:\"sidebar_padding\";s:1:\"0\";s:16:\"sidebar_bg_color\";s:7:\"#ffffff\";s:23:\"sidebar_widget_bg_color\";s:19:\"rgba(255,255,255,0)\";s:15:\"sidew_font_size\";s:4:\"14px\";s:21:\"sidebar_heading_color\";s:7:\"#333333\";s:20:\"pages_global_sidebar\";s:1:\"0\";s:13:\"pages_sidebar\";s:4:\"None\";s:15:\"pages_sidebar_2\";s:4:\"None\";s:19:\"default_sidebar_pos\";s:5:\"Right\";s:24:\"portfolio_global_sidebar\";s:1:\"0\";s:17:\"portfolio_sidebar\";s:4:\"None\";s:19:\"portfolio_sidebar_2\";s:4:\"None\";s:26:\"portfolio_sidebar_position\";s:5:\"Right\";s:25:\"portfolio_archive_sidebar\";s:4:\"None\";s:27:\"portfolio_archive_sidebar_2\";s:4:\"None\";s:20:\"posts_global_sidebar\";s:1:\"0\";s:13:\"posts_sidebar\";s:4:\"None\";s:15:\"posts_sidebar_2\";s:4:\"None\";s:21:\"blog_sidebar_position\";s:5:\"Right\";s:20:\"blog_archive_sidebar\";s:12:\"Blog Sidebar\";s:22:\"blog_archive_sidebar_2\";s:4:\"None\";s:14:\"search_sidebar\";s:12:\"Blog Sidebar\";s:16:\"search_sidebar_2\";s:4:\"None\";s:23:\"search_sidebar_position\";s:5:\"Right\";s:8:\"bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"bg_full\";s:1:\"0\";s:9:\"bg_repeat\";s:6:\"repeat\";s:8:\"bg_color\";s:7:\"#ffffff\";s:17:\"bg_pattern_option\";s:1:\"0\";s:10:\"bg_pattern\";s:8:\"pattern1\";s:16:\"content_bg_color\";s:7:\"#ffffff\";s:16:\"content_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"content_bg_full\";s:1:\"0\";s:17:\"content_bg_repeat\";s:6:\"repeat\";s:15:\"body_typography\";a:11:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:5:\"Vazir\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"13px\";s:11:\"line-height\";s:4:\"1.69\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#747474\";}s:10:\"link_color\";s:7:\"#333333\";s:13:\"h1_typography\";a:13:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"33px\";s:11:\"line-height\";s:4:\"1.45\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"0.67em\";s:13:\"margin-bottom\";s:6:\"0.67em\";s:5:\"color\";s:7:\"#333333\";}s:13:\"h2_typography\";a:13:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"0em\";s:13:\"margin-bottom\";s:4:\".7em\";s:5:\"color\";s:7:\"#333333\";}s:13:\"h3_typography\";a:13:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"17px\";s:11:\"line-height\";s:4:\"1.41\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"1em\";s:13:\"margin-bottom\";s:3:\"1em\";s:5:\"color\";s:7:\"#333333\";}s:13:\"h4_typography\";a:13:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"1.43\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"1.33em\";s:13:\"margin-bottom\";s:6:\"1.33em\";s:5:\"color\";s:7:\"#333333\";}s:13:\"h5_typography\";a:13:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"13px\";s:11:\"line-height\";s:4:\"1.38\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"1.67em\";s:13:\"margin-bottom\";s:6:\"1.67em\";s:5:\"color\";s:7:\"#333333\";}s:13:\"h6_typography\";a:13:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:4:\"1.42\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"2.33em\";s:13:\"margin-bottom\";s:6:\"2.33em\";s:5:\"color\";s:7:\"#333333\";}s:21:\"post_title_typography\";a:11:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:4:\"27px\";s:14:\"letter-spacing\";s:3:\"0px\";s:5:\"color\";s:7:\"#333333\";}s:29:\"post_titles_extras_typography\";a:11:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:4:\"1.41\";s:14:\"letter-spacing\";s:3:\"0px\";s:5:\"color\";s:7:\"#333333\";}s:12:\"custom_fonts\";a:7:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"name\";a:1:{i:0;s:0:\"\";}s:4:\"woff\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:5:\"woff2\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"ttf\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"svg\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"eot\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:19:\"blog_page_title_bar\";s:15:\"bar_and_content\";s:24:\"blog_show_page_title_bar\";s:15:\"bar_and_content\";s:10:\"blog_title\";s:4:\"Blog\";s:13:\"blog_subtitle\";s:0:\"\";s:11:\"blog_layout\";s:4:\"grid\";s:19:\"blog_archive_layout\";s:4:\"grid\";s:20:\"blog_pagination_type\";s:10:\"pagination\";s:36:\"blog_load_more_posts_button_bg_color\";s:7:\"#ebeaea\";s:25:\"blog_archive_grid_columns\";s:1:\"3\";s:32:\"blog_archive_grid_column_spacing\";s:2:\"40\";s:18:\"blog_equal_heights\";s:1:\"0\";s:25:\"blog_archive_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:21:\"blog_layout_alignment\";s:0:\"\";s:14:\"content_length\";s:7:\"excerpt\";s:19:\"excerpt_length_blog\";s:2:\"56\";s:18:\"strip_html_excerpt\";s:1:\"1\";s:15:\"featured_images\";s:1:\"1\";s:32:\"alternate_date_format_month_year\";s:4:\"m, Y\";s:25:\"alternate_date_format_day\";s:1:\"j\";s:20:\"timeline_date_format\";s:3:\"F Y\";s:14:\"blog_width_100\";s:1:\"0\";s:22:\"featured_images_single\";s:1:\"1\";s:11:\"blog_pn_nav\";s:1:\"1\";s:15:\"blog_post_title\";s:5:\"below\";s:23:\"blog_post_meta_position\";s:13:\"below_article\";s:11:\"author_info\";s:1:\"1\";s:18:\"social_sharing_box\";s:1:\"1\";s:13:\"related_posts\";s:1:\"1\";s:13:\"blog_comments\";s:1:\"1\";s:9:\"post_meta\";s:1:\"1\";s:16:\"post_meta_author\";s:1:\"1\";s:14:\"post_meta_date\";s:1:\"1\";s:14:\"post_meta_cats\";s:1:\"1\";s:18:\"post_meta_comments\";s:1:\"1\";s:14:\"post_meta_read\";s:1:\"1\";s:14:\"post_meta_tags\";s:1:\"1\";s:14:\"meta_font_size\";s:4:\"12px\";s:11:\"date_format\";s:7:\"F jS, Y\";s:24:\"portfolio_archive_layout\";s:4:\"grid\";s:37:\"portfolio_archive_featured_image_size\";s:4:\"full\";s:25:\"portfolio_archive_columns\";s:1:\"2\";s:32:\"portfolio_archive_column_spacing\";s:2:\"12\";s:23:\"portfolio_equal_heights\";s:1:\"0\";s:42:\"portfolio_archive_one_column_text_position\";s:5:\"below\";s:23:\"portfolio_archive_items\";s:1:\"4\";s:29:\"portfolio_archive_text_layout\";s:7:\"no_text\";s:32:\"portfolio_archive_content_length\";s:7:\"excerpt\";s:32:\"portfolio_archive_excerpt_length\";s:2:\"58\";s:36:\"portfolio_archive_strip_html_excerpt\";s:1:\"1\";s:31:\"portfolio_archive_title_display\";s:3:\"all\";s:32:\"portfolio_archive_text_alignment\";s:4:\"left\";s:32:\"portfolio_archive_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:33:\"portfolio_archive_pagination_type\";s:15:\"infinite_scroll\";s:49:\"portfolio_archive_load_more_posts_button_bg_color\";s:7:\"#ebeaea\";s:14:\"portfolio_slug\";s:15:\"portfolio-items\";s:24:\"portfolio_meta_font_size\";s:4:\"14px\";s:16:\"portfolio_pn_nav\";s:1:\"1\";s:25:\"portfolio_featured_images\";s:1:\"1\";s:38:\"portfolio_disable_first_featured_image\";s:1:\"1\";s:30:\"portfolio_featured_image_width\";s:4:\"full\";s:19:\"portfolio_width_100\";s:1:\"0\";s:28:\"portfolio_project_desc_title\";s:1:\"1\";s:25:\"portfolio_project_details\";s:1:\"1\";s:26:\"portfolio_link_icon_target\";s:1:\"0\";s:18:\"portfolio_comments\";s:1:\"0\";s:16:\"portfolio_author\";s:1:\"0\";s:28:\"portfolio_social_sharing_box\";s:1:\"0\";s:23:\"portfolio_related_posts\";s:1:\"1\";s:18:\"social_media_icons\";a:5:{s:25:\"fusionredux_repeater_data\";a:6:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}i:5;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"icon\";a:6:{i:0;s:8:\"facebook\";i:1;s:5:\"gplus\";i:2;s:9:\"instagram\";i:3;s:8:\"linkedin\";i:4;s:8:\"whatsapp\";i:5;s:3:\"rss\";}s:3:\"url\";a:6:{i:0;s:1:\"#\";i:1;s:1:\"#\";i:2;s:1:\"#\";i:3;s:1:\"#\";i:4;s:1:\"#\";i:5;s:1:\"#\";}s:12:\"custom_title\";a:6:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:13:\"custom_source\";a:6:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:3;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:4;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:5;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:29:\"header_social_links_font_size\";s:4:\"16px\";s:37:\"header_social_links_tooltip_placement\";s:6:\"bottom\";s:30:\"header_social_links_color_type\";s:6:\"custom\";s:30:\"header_social_links_icon_color\";s:7:\"#ffffff\";s:25:\"header_social_links_boxed\";s:1:\"0\";s:29:\"header_social_links_box_color\";s:7:\"#e8e8e8\";s:32:\"header_social_links_boxed_radius\";s:3:\"4px\";s:33:\"header_social_links_boxed_padding\";s:3:\"8px\";s:12:\"icons_footer\";s:1:\"1\";s:29:\"footer_social_links_font_size\";s:4:\"18px\";s:37:\"footer_social_links_tooltip_placement\";s:3:\"top\";s:30:\"footer_social_links_color_type\";s:6:\"custom\";s:30:\"footer_social_links_icon_color\";s:7:\"#46494a\";s:25:\"footer_social_links_boxed\";s:1:\"0\";s:29:\"footer_social_links_box_color\";s:7:\"#222222\";s:32:\"footer_social_links_boxed_radius\";s:3:\"4px\";s:33:\"footer_social_links_boxed_padding\";s:3:\"8px\";s:22:\"sharing_social_tagline\";s:39:\"Share This Story, Choose Your Platform!\";s:30:\"sharing_box_tagline_text_color\";s:7:\"#333333\";s:15:\"social_bg_color\";s:7:\"#f6f6f6\";s:30:\"sharing_social_links_font_size\";s:4:\"16px\";s:38:\"sharing_social_links_tooltip_placement\";s:3:\"top\";s:31:\"sharing_social_links_color_type\";s:6:\"custom\";s:31:\"sharing_social_links_icon_color\";s:7:\"#bebdbd\";s:26:\"sharing_social_links_boxed\";s:1:\"1\";s:30:\"sharing_social_links_box_color\";s:7:\"#e8e8e8\";s:33:\"sharing_social_links_boxed_radius\";s:3:\"4px\";s:34:\"sharing_social_links_boxed_padding\";s:3:\"8px\";s:16:\"sharing_facebook\";s:1:\"1\";s:15:\"sharing_twitter\";s:1:\"1\";s:14:\"sharing_reddit\";s:1:\"1\";s:16:\"sharing_linkedin\";s:1:\"1\";s:16:\"sharing_whatsapp\";s:1:\"0\";s:14:\"sharing_google\";s:1:\"1\";s:14:\"sharing_tumblr\";s:1:\"0\";s:17:\"sharing_pinterest\";s:1:\"1\";s:10:\"sharing_vk\";s:1:\"1\";s:13:\"sharing_email\";s:1:\"0\";s:22:\"posts_slideshow_number\";s:1:\"5\";s:18:\"slideshow_autoplay\";s:1:\"1\";s:23:\"slideshow_smooth_height\";s:1:\"0\";s:15:\"slideshow_speed\";s:4:\"7000\";s:22:\"pagination_video_slide\";s:1:\"0\";s:25:\"slider_nav_box_dimensions\";a:2:{s:5:\"width\";s:4:\"30px\";s:6:\"height\";s:4:\"30px\";}s:17:\"slider_arrow_size\";s:4:\"14px\";s:15:\"tfes_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"550px\";}s:14:\"tfes_animation\";s:5:\"sides\";s:13:\"tfes_autoplay\";s:1:\"1\";s:13:\"tfes_interval\";s:4:\"3000\";s:10:\"tfes_speed\";s:3:\"800\";s:10:\"tfes_width\";s:3:\"200\";s:18:\"es_title_font_size\";s:4:\"42px\";s:20:\"es_caption_font_size\";s:4:\"20px\";s:14:\"es_title_color\";s:7:\"#333333\";s:16:\"es_caption_color\";s:7:\"#747474\";s:15:\"status_lightbox\";s:1:\"1\";s:22:\"status_lightbox_single\";s:1:\"1\";s:17:\"lightbox_behavior\";s:3:\"all\";s:13:\"lightbox_skin\";s:11:\"metro-white\";s:13:\"lightbox_path\";s:10:\"horizontal\";s:24:\"lightbox_animation_speed\";s:4:\"fast\";s:15:\"lightbox_arrows\";s:1:\"1\";s:16:\"lightbox_gallery\";s:1:\"1\";s:17:\"lightbox_autoplay\";s:1:\"0\";s:24:\"lightbox_slideshow_speed\";s:4:\"5000\";s:16:\"lightbox_opacity\";s:4:\"0.97\";s:14:\"lightbox_title\";s:1:\"0\";s:13:\"lightbox_desc\";s:1:\"0\";s:15:\"lightbox_social\";s:1:\"1\";s:20:\"lightbox_deeplinking\";s:1:\"1\";s:20:\"lightbox_post_images\";s:1:\"0\";s:25:\"lightbox_video_dimensions\";a:2:{s:5:\"width\";s:6:\"1280px\";s:6:\"height\";s:5:\"720px\";}s:13:\"email_address\";s:17:\"noemail@email.com\";s:24:\"contact_comment_position\";s:5:\"below\";s:29:\"contact_form_privacy_checkbox\";s:1:\"0\";s:26:\"contact_form_privacy_label\";s:152:\"By checking this box, you confirm that you have read and are agreeing to our terms of use regarding the storage of the data submitted through this form.\";s:17:\"recaptcha_version\";s:2:\"v2\";s:16:\"recaptcha_public\";s:0:\"\";s:17:\"recaptcha_private\";s:0:\"\";s:22:\"recaptcha_color_scheme\";s:5:\"light\";s:15:\"recaptcha_score\";s:3:\"0.5\";s:24:\"recaptcha_badge_position\";s:6:\"inline\";s:8:\"gmap_api\";s:0:\"\";s:13:\"gmap_api_type\";s:2:\"js\";s:18:\"gmap_embed_address\";s:0:\"\";s:19:\"gmap_embed_map_type\";s:7:\"roadmap\";s:12:\"gmap_address\";s:46:\"New York City, NY | Flemington, NJ | Islip, NY\";s:9:\"gmap_type\";s:7:\"roadmap\";s:15:\"gmap_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"415px\";}s:14:\"gmap_topmargin\";s:4:\"55px\";s:14:\"map_zoom_level\";s:1:\"9\";s:7:\"map_pin\";s:1:\"1\";s:18:\"gmap_pin_animation\";s:1:\"1\";s:9:\"map_popup\";s:1:\"0\";s:15:\"map_scrollwheel\";s:1:\"1\";s:9:\"map_scale\";s:1:\"1\";s:15:\"map_zoomcontrol\";s:1:\"1\";s:11:\"map_styling\";s:6:\"custom\";s:17:\"map_overlay_color\";s:7:\"#70b260\";s:19:\"map_infobox_styling\";s:6:\"custom\";s:19:\"map_infobox_content\";s:222:\"Jason At New York City Office Park 555 West Street, New York City 12345|Allison At The Flemington Office Park 555 East Street, New York City 12345|Johnathan At The Islips Office Park 555 South Street, New York City 12345\r\n\";s:20:\"map_infobox_bg_color\";s:14:\"rgba(0,0,0,.5)\";s:22:\"map_infobox_text_color\";s:7:\"#ffffff\";s:22:\"map_custom_marker_icon\";s:224:\"https://avada.theme-fusion.com/wp-content/uploads/2014/06/map_avatar_2.png|https://avada.theme-fusion.com/wp-content/uploads/2014/06/map_avatar_1.png|https://avada.theme-fusion.com/wp-content/uploads/2014/06/map_avatar_3.png\";s:14:\"search_content\";a:6:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:15:\"avada_portfolio\";i:3;s:9:\"avada_faq\";i:4;s:7:\"product\";i:5;s:12:\"tribe_events\";}s:27:\"search_limit_to_post_titles\";s:1:\"0\";s:18:\"search_form_design\";s:7:\"classic\";s:11:\"live_search\";s:1:\"0\";s:26:\"live_search_min_char_count\";s:1:\"4\";s:28:\"live_search_results_per_page\";s:3:\"100\";s:26:\"live_search_results_height\";s:3:\"250\";s:34:\"live_search_display_featured_image\";s:1:\"1\";s:29:\"live_search_display_post_type\";s:1:\"1\";s:13:\"search_layout\";s:4:\"grid\";s:23:\"search_results_per_page\";s:1:\"8\";s:22:\"search_pagination_type\";s:10:\"pagination\";s:19:\"search_grid_columns\";s:1:\"3\";s:26:\"search_grid_column_spacing\";s:2:\"40\";s:21:\"search_content_length\";s:7:\"excerpt\";s:21:\"search_excerpt_length\";s:2:\"56\";s:25:\"search_strip_html_excerpt\";s:1:\"1\";s:22:\"search_featured_images\";s:1:\"1\";s:11:\"search_meta\";a:6:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:9:\"read_more\";i:5;s:4:\"tags\";}s:26:\"search_new_search_position\";s:3:\"top\";s:18:\"gfonts_load_method\";s:3:\"cdn\";s:14:\"privacy_embeds\";s:1:\"0\";s:14:\"privacy_expiry\";s:2:\"30\";s:19:\"privacy_embed_types\";a:7:{i:0;s:7:\"youtube\";i:1;s:5:\"vimeo\";i:2;s:10:\"soundcloud\";i:3;s:8:\"facebook\";i:4;s:6:\"flickr\";i:5;s:7:\"twitter\";i:6;s:5:\"gmaps\";}s:22:\"privacy_embed_defaults\";a:0:{}s:16:\"privacy_bg_color\";s:15:\"rgba(0,0,0,0.1)\";s:13:\"privacy_color\";s:15:\"rgba(0,0,0,0.3)\";s:11:\"privacy_bar\";s:1:\"0\";s:19:\"privacy_bar_padding\";a:4:{s:3:\"top\";s:4:\"15px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"15px\";s:4:\"left\";s:4:\"30px\";}s:20:\"privacy_bar_bg_color\";s:7:\"#363839\";s:21:\"privacy_bar_font_size\";s:4:\"13px\";s:17:\"privacy_bar_color\";s:7:\"#8C8989\";s:22:\"privacy_bar_link_color\";s:7:\"#bfbfbf\";s:28:\"privacy_bar_link_hover_color\";s:7:\"#a0ce4e\";s:16:\"privacy_bar_text\";s:51:\"This website uses cookies and third party services.\";s:23:\"privacy_bar_button_text\";s:2:\"Ok\";s:23:\"privacy_bar_button_save\";s:1:\"0\";s:16:\"privacy_bar_more\";s:1:\"0\";s:21:\"privacy_bar_more_text\";s:8:\"Settings\";s:23:\"privacy_bar_update_text\";s:15:\"Update Settings\";s:30:\"privacy_bar_headings_font_size\";s:4:\"13px\";s:26:\"privacy_bar_headings_color\";s:7:\"#dddddd\";s:19:\"privacy_bar_content\";a:4:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"type\";a:1:{i:0;s:0:\"\";}s:5:\"title\";a:1:{i:0;s:0:\"\";}s:11:\"description\";a:1:{i:0;s:0:\"\";}}s:16:\"sidenav_behavior\";s:5:\"hover\";s:26:\"featured_image_placeholder\";s:1:\"0\";s:12:\"excerpt_base\";s:5:\"words\";s:16:\"disable_excerpts\";s:1:\"1\";s:14:\"link_read_more\";s:1:\"0\";s:12:\"avatar_shape\";s:6:\"square\";s:14:\"comments_pages\";s:1:\"0\";s:21:\"featured_images_pages\";s:1:\"1\";s:21:\"nofollow_social_links\";s:1:\"0\";s:16:\"social_icons_new\";s:1:\"1\";s:14:\"totop_position\";s:4:\"left\";s:19:\"totop_border_radius\";s:1:\"4\";s:22:\"totop_scroll_down_only\";s:1:\"0\";s:20:\"related_posts_layout\";s:17:\"title_below_image\";s:20:\"number_related_posts\";s:1:\"5\";s:21:\"related_posts_columns\";s:1:\"3\";s:28:\"related_posts_column_spacing\";s:2:\"20\";s:24:\"related_posts_image_size\";s:7:\"cropped\";s:22:\"related_posts_autoplay\";s:1:\"1\";s:19:\"related_posts_speed\";s:4:\"2500\";s:24:\"related_posts_navigation\";s:1:\"1\";s:19:\"related_posts_swipe\";s:1:\"0\";s:25:\"related_posts_swipe_items\";s:1:\"1\";s:14:\"image_rollover\";s:1:\"1\";s:24:\"image_rollover_direction\";s:4:\"left\";s:24:\"image_rollover_icon_size\";s:4:\"17px\";s:19:\"link_image_rollover\";s:1:\"1\";s:19:\"zoom_image_rollover\";s:1:\"1\";s:20:\"title_image_rollover\";s:1:\"1\";s:19:\"cats_image_rollover\";s:1:\"1\";s:26:\"icon_circle_image_rollover\";s:1:\"1\";s:24:\"image_gradient_top_color\";s:22:\"rgba(160,206,78,0.925)\";s:27:\"image_gradient_bottom_color\";s:7:\"#a0ce4e\";s:25:\"image_rollover_text_color\";s:7:\"#333333\";s:25:\"image_rollover_icon_color\";s:7:\"#ffffff\";s:17:\"pagination_sizing\";s:7:\"padding\";s:23:\"pagination_width_height\";s:2:\"30\";s:22:\"pagination_box_padding\";a:2:{s:5:\"width\";s:3:\"6px\";s:6:\"height\";s:3:\"2px\";}s:24:\"pagination_border_radius\";s:1:\"0\";s:23:\"pagination_text_display\";s:1:\"1\";s:20:\"pagination_font_size\";s:4:\"12px\";s:16:\"pagination_range\";s:1:\"1\";s:26:\"pagination_start_end_range\";s:1:\"0\";s:17:\"form_input_height\";s:4:\"38px\";s:13:\"form_bg_color\";s:7:\"#ffffff\";s:14:\"form_text_size\";s:4:\"13px\";s:15:\"form_text_color\";s:7:\"#aaa9a9\";s:17:\"form_border_width\";a:4:{s:3:\"top\";s:3:\"1px\";s:5:\"right\";s:3:\"1px\";s:6:\"bottom\";s:3:\"1px\";s:4:\"left\";s:3:\"1px\";}s:17:\"form_border_color\";s:7:\"#d2d2d2\";s:23:\"form_focus_border_color\";s:7:\"#d2d2d2\";s:18:\"form_border_radius\";s:1:\"0\";s:17:\"timeline_bg_color\";s:19:\"rgba(255,255,255,0)\";s:14:\"timeline_color\";s:7:\"#ebeaea\";s:25:\"grid_separator_style_type\";s:12:\"double|solid\";s:20:\"grid_separator_color\";s:7:\"#e0dede\";s:18:\"masonry_grid_ratio\";s:1:\"1\";s:20:\"masonry_width_double\";s:4:\"2000\";s:16:\"google_analytics\";s:0:\"\";s:10:\"space_head\";s:0:\"\";s:10:\"space_body\";s:0:\"\";s:19:\"dependencies_status\";s:1:\"1\";s:15:\"pw_jpeg_quality\";s:3:\"100\";s:16:\"smooth_scrolling\";s:1:\"0\";s:27:\"disable_code_block_encoding\";s:1:\"1\";s:16:\"disable_megamenu\";s:1:\"1\";s:16:\"avada_rev_styles\";s:1:\"1\";s:22:\"avada_styles_dropdowns\";s:1:\"1\";s:27:\"disable_mobile_image_hovers\";s:1:\"1\";s:9:\"status_yt\";s:1:\"1\";s:12:\"status_vimeo\";s:1:\"1\";s:11:\"status_gmap\";s:1:\"1\";s:12:\"status_totop\";s:18:\"desktop_and_mobile\";s:20:\"status_fusion_slider\";s:1:\"1\";s:14:\"status_eslider\";s:1:\"1\";s:18:\"status_fontawesome\";a:3:{i:0;s:3:\"fab\";i:1;s:3:\"far\";i:2;s:3:\"fas\";}s:28:\"fontawesome_v4_compatibility\";s:1:\"1\";s:22:\"status_fontawesome_pro\";s:1:\"0\";s:14:\"status_outline\";s:1:\"0\";s:16:\"status_opengraph\";s:1:\"1\";s:31:\"disable_date_rich_snippet_pages\";s:1:\"1\";s:26:\"disable_rich_snippet_title\";s:1:\"1\";s:27:\"disable_rich_snippet_author\";s:1:\"1\";s:25:\"disable_rich_snippet_date\";s:1:\"1\";s:9:\"lazy_load\";s:4:\"none\";s:17:\"font_face_display\";s:5:\"block\";s:15:\"emojis_disabled\";s:7:\"enabled\";s:16:\"css_cache_method\";s:4:\"file\";s:19:\"media_queries_async\";s:1:\"0\";s:15:\"cache_server_ip\";s:0:\"\";s:11:\"js_compiler\";s:1:\"0\";s:10:\"custom_css\";s:0:\"\";s:13:\"info_bg_color\";s:7:\"#ffffff\";s:17:\"info_accent_color\";s:19:\"rgba(128,128,128,1)\";s:15:\"danger_bg_color\";s:7:\"#f2dede\";s:19:\"danger_accent_color\";s:17:\"rgba(166,66,66,1)\";s:16:\"success_bg_color\";s:7:\"#dff0d8\";s:20:\"success_accent_color\";s:17:\"rgba(92,163,64,1)\";s:16:\"warning_bg_color\";s:7:\"#fcf8e3\";s:20:\"warning_accent_color\";s:18:\"rgba(217,185,23,1)\";s:20:\"alert_box_text_align\";s:6:\"center\";s:24:\"alert_box_text_transform\";s:10:\"capitalize\";s:21:\"alert_box_dismissable\";s:3:\"yes\";s:16:\"alert_box_shadow\";s:2:\"no\";s:17:\"alert_border_size\";s:1:\"1\";s:16:\"animation_offset\";s:13:\"top-into-view\";s:17:\"blog_grid_columns\";s:1:\"2\";s:24:\"blog_grid_column_spacing\";s:2:\"40\";s:17:\"blog_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:12:\"blog_excerpt\";s:3:\"yes\";s:19:\"blog_excerpt_length\";s:2:\"10\";s:15:\"dates_box_color\";s:7:\"#eef0f2\";s:11:\"button_size\";s:5:\"Large\";s:11:\"button_span\";s:2:\"no\";s:11:\"button_type\";s:4:\"Flat\";s:17:\"button_typography\";a:8:{s:11:\"font-family\";s:5:\"Vazir\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:5:\"Vazir\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"letter-spacing\";s:3:\"0px\";}s:21:\"button_text_transform\";s:9:\"uppercase\";s:25:\"button_gradient_top_color\";s:7:\"#a0ce4e\";s:28:\"button_gradient_bottom_color\";s:7:\"#a0ce4e\";s:31:\"button_gradient_top_color_hover\";s:7:\"#96c346\";s:34:\"button_gradient_bottom_color_hover\";s:7:\"#96c346\";s:19:\"button_accent_color\";s:20:\"rgba(255,255,255,.8)\";s:25:\"button_accent_hover_color\";s:20:\"rgba(255,255,255,.9)\";s:18:\"button_bevel_color\";s:7:\"#54770f\";s:19:\"button_border_width\";s:1:\"0\";s:18:\"carousel_nav_color\";s:14:\"rgba(0,0,0,.5)\";s:20:\"carousel_hover_color\";s:14:\"rgba(0,0,0,.6)\";s:14:\"carousel_speed\";s:4:\"2500\";s:21:\"chart_legend_position\";s:3:\"top\";s:19:\"chart_show_tooltips\";s:3:\"yes\";s:14:\"chart_bg_color\";s:19:\"rgba(255,255,255,0)\";s:21:\"chart_axis_text_color\";s:7:\"#666666\";s:20:\"chart_gridline_color\";s:15:\"rgba(0,0,0,0.1)\";s:21:\"checklist_icons_color\";s:7:\"#ffffff\";s:16:\"checklist_circle\";s:1:\"1\";s:22:\"checklist_circle_color\";s:7:\"#a0ce4e\";s:19:\"checklist_item_size\";s:4:\"14px\";s:17:\"checklist_divider\";s:2:\"no\";s:23:\"checklist_divider_color\";s:7:\"#e0dede\";s:10:\"col_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";}s:25:\"container_padding_default\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:21:\"container_padding_100\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:4:\"30px\";}s:19:\"full_width_bg_color\";s:7:\"#ffffff\";s:22:\"full_width_border_size\";s:1:\"0\";s:23:\"full_width_border_color\";s:7:\"#eae9e9\";s:29:\"container_scroll_nav_bg_color\";s:18:\"rgba(0, 0, 0, 0.2)\";s:33:\"container_scroll_nav_bullet_color\";s:7:\"#eeeeee\";s:39:\"container_hundred_percent_height_mobile\";s:1:\"0\";s:20:\"content_box_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"content_box_title_size\";s:2:\"18\";s:23:\"content_box_title_color\";s:7:\"#333333\";s:22:\"content_box_body_color\";s:7:\"#747474\";s:21:\"content_box_icon_size\";s:2:\"21\";s:22:\"content_box_icon_color\";s:7:\"#ffffff\";s:23:\"content_box_icon_circle\";s:3:\"yes\";s:30:\"content_box_icon_circle_radius\";s:3:\"50%\";s:25:\"content_box_icon_bg_color\";s:7:\"#333333\";s:38:\"content_box_icon_bg_inner_border_color\";s:7:\"#333333\";s:37:\"content_box_icon_bg_inner_border_size\";s:1:\"1\";s:38:\"content_box_icon_bg_outer_border_color\";s:19:\"rgba(255,255,255,0)\";s:37:\"content_box_icon_bg_outer_border_size\";s:1:\"0\";s:27:\"content_box_icon_hover_type\";s:4:\"fade\";s:40:\"content_box_hover_animation_accent_color\";s:7:\"#a0ce4e\";s:21:\"content_box_link_type\";s:4:\"text\";s:23:\"content_box_button_span\";s:2:\"no\";s:21:\"content_box_link_area\";s:9:\"link-icon\";s:23:\"content_box_link_target\";s:5:\"_self\";s:18:\"content_box_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"60px\";}s:18:\"countdown_timezone\";s:9:\"site_time\";s:20:\"countdown_show_weeks\";s:2:\"no\";s:26:\"countdown_background_color\";s:7:\"#a0ce4e\";s:26:\"countdown_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"countdown_background_repeat\";s:9:\"no-repeat\";s:29:\"countdown_background_position\";s:13:\"center center\";s:27:\"countdown_counter_box_color\";s:7:\"#333333\";s:28:\"countdown_counter_text_color\";s:7:\"#ffffff\";s:28:\"countdown_heading_text_color\";s:7:\"#ffffff\";s:31:\"countdown_subheading_text_color\";s:7:\"#ffffff\";s:25:\"countdown_link_text_color\";s:7:\"#ffffff\";s:21:\"countdown_link_target\";s:5:\"_self\";s:17:\"counter_box_speed\";s:4:\"1000\";s:17:\"counter_box_color\";s:7:\"#a0ce4e\";s:22:\"counter_box_title_size\";s:4:\"50px\";s:21:\"counter_box_icon_size\";s:4:\"50px\";s:22:\"counter_box_body_color\";s:7:\"#747474\";s:21:\"counter_box_body_size\";s:4:\"13px\";s:24:\"counter_box_border_color\";s:7:\"#e0dede\";s:20:\"counter_box_icon_top\";s:2:\"no\";s:20:\"counter_filled_color\";s:7:\"#a0ce4e\";s:22:\"counter_unfilled_color\";s:7:\"#f6f6f6\";s:13:\"dropcap_color\";s:7:\"#a0ce4e\";s:15:\"events_per_page\";s:1:\"4\";s:21:\"events_column_spacing\";s:2:\"-1\";s:22:\"events_content_padding\";a:4:{s:3:\"top\";s:4:\"20px\";s:5:\"right\";s:4:\"20px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"20px\";}s:21:\"events_content_length\";s:7:\"no_text\";s:21:\"excerpt_length_events\";s:2:\"55\";s:25:\"events_strip_html_excerpt\";s:1:\"1\";s:18:\"faq_featured_image\";s:1:\"0\";s:11:\"faq_filters\";s:3:\"yes\";s:18:\"faq_accordion_type\";s:10:\"accordions\";s:24:\"faq_accordion_boxed_mode\";s:1:\"0\";s:25:\"faq_accordion_border_size\";s:1:\"1\";s:26:\"faq_accordian_border_color\";s:7:\"#cccccc\";s:30:\"faq_accordian_background_color\";s:7:\"#ffffff\";s:25:\"faq_accordian_hover_color\";s:7:\"#f9f9f9\";s:26:\"faq_accordion_divider_line\";s:1:\"1\";s:29:\"faq_accordion_title_font_size\";s:4:\"14px\";s:23:\"faq_accordion_icon_size\";s:2:\"13\";s:24:\"faq_accordian_icon_color\";s:7:\"#ffffff\";s:24:\"faq_accordion_icon_boxed\";s:1:\"1\";s:28:\"faq_accordian_inactive_color\";s:7:\"#333333\";s:24:\"faq_accordion_icon_align\";s:4:\"left\";s:26:\"faq_accordian_active_color\";s:7:\"#a0ce4e\";s:22:\"flip_boxes_flip_effect\";s:7:\"classic\";s:25:\"flip_boxes_flip_direction\";s:5:\"right\";s:24:\"flip_boxes_flip_duration\";s:3:\"0.4\";s:24:\"flip_boxes_equal_heights\";s:2:\"no\";s:19:\"flip_boxes_front_bg\";s:7:\"#f6f6f6\";s:24:\"flip_boxes_front_heading\";s:7:\"#333333\";s:21:\"flip_boxes_front_text\";s:7:\"#747474\";s:18:\"flip_boxes_back_bg\";s:7:\"#a0ce4e\";s:23:\"flip_boxes_back_heading\";s:7:\"#eeeded\";s:20:\"flip_boxes_back_text\";s:7:\"#ffffff\";s:22:\"flip_boxes_border_size\";s:1:\"1\";s:23:\"flip_boxes_border_color\";s:19:\"rgba(255,255,255,0)\";s:24:\"flip_boxes_border_radius\";s:3:\"4px\";s:17:\"icon_circle_color\";s:7:\"#333333\";s:17:\"icon_border_color\";s:7:\"#333333\";s:10:\"icon_color\";s:7:\"#ffffff\";s:20:\"gallery_picture_size\";s:4:\"auto\";s:14:\"gallery_layout\";s:4:\"grid\";s:15:\"gallery_columns\";s:1:\"3\";s:22:\"gallery_column_spacing\";s:2:\"10\";s:18:\"gallery_hover_type\";s:4:\"none\";s:24:\"gallery_lightbox_content\";s:4:\"none\";s:19:\"gallery_border_size\";s:1:\"0\";s:20:\"gallery_border_color\";s:7:\"#f6f6f6\";s:21:\"gallery_border_radius\";s:3:\"0px\";s:19:\"google_map_api_type\";s:2:\"js\";s:21:\"imageframe_style_type\";s:4:\"none\";s:15:\"imageframe_blur\";s:1:\"3\";s:20:\"imgframe_style_color\";s:7:\"#000000\";s:22:\"imageframe_border_size\";s:1:\"0\";s:21:\"imgframe_border_color\";s:7:\"#f6f6f6\";s:24:\"imageframe_border_radius\";s:1:\"0\";s:17:\"before_after_type\";s:12:\"before_after\";s:22:\"before_after_font_size\";s:2:\"13\";s:25:\"before_after_accent_color\";s:7:\"#ffffff\";s:28:\"before_after_label_placement\";s:14:\"image-centered\";s:24:\"before_after_handle_type\";s:7:\"default\";s:25:\"before_after_handle_color\";s:7:\"#ffffff\";s:22:\"before_after_handle_bg\";s:19:\"rgba(255,255,255,0)\";s:19:\"before_after_offset\";s:2:\"50\";s:24:\"before_after_orientation\";s:10:\"horizontal\";s:28:\"before_after_handle_movement\";s:10:\"drag_click\";s:28:\"before_after_transition_time\";s:3:\"0.5\";s:14:\"modal_bg_color\";s:7:\"#f6f6f6\";s:18:\"modal_border_color\";s:7:\"#ebebeb\";s:23:\"person_background_color\";s:13:\"rgba(0,0,0,0)\";s:16:\"person_pic_style\";s:4:\"none\";s:21:\"person_pic_style_blur\";s:1:\"3\";s:18:\"person_style_color\";s:7:\"#000000\";s:19:\"person_border_color\";s:7:\"#f6f6f6\";s:18:\"person_border_size\";s:1:\"0\";s:20:\"person_border_radius\";s:1:\"0\";s:16:\"person_alignment\";s:4:\"Left\";s:20:\"person_icon_position\";s:3:\"Top\";s:24:\"popover_heading_bg_color\";s:7:\"#f6f6f6\";s:24:\"popover_content_bg_color\";s:7:\"#ffffff\";s:20:\"popover_border_color\";s:7:\"#eaeaea\";s:18:\"popover_text_color\";s:7:\"#747474\";s:17:\"popover_placement\";s:3:\"Top\";s:29:\"portfolio_featured_image_size\";s:4:\"full\";s:17:\"portfolio_columns\";s:1:\"3\";s:24:\"portfolio_column_spacing\";s:2:\"12\";s:15:\"portfolio_items\";s:2:\"10\";s:21:\"portfolio_text_layout\";s:7:\"unboxed\";s:24:\"portfolio_content_length\";s:7:\"excerpt\";s:24:\"portfolio_excerpt_length\";s:2:\"58\";s:28:\"portfolio_strip_html_excerpt\";s:1:\"1\";s:23:\"portfolio_title_display\";s:3:\"all\";s:24:\"portfolio_text_alignment\";s:4:\"left\";s:24:\"portfolio_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:25:\"portfolio_pagination_type\";s:15:\"infinite_scroll\";s:36:\"full_boxed_pricing_box_heading_color\";s:7:\"#333333\";s:29:\"sep_pricing_box_heading_color\";s:7:\"#333333\";s:17:\"pricing_box_color\";s:7:\"#a0ce4e\";s:16:\"pricing_bg_color\";s:7:\"#ffffff\";s:30:\"pricing_background_color_hover\";s:7:\"#f8f8f8\";s:20:\"pricing_border_color\";s:7:\"#f8f8f8\";s:21:\"pricing_divider_color\";s:7:\"#ededed\";s:18:\"progressbar_height\";s:4:\"37px\";s:25:\"progressbar_text_position\";s:6:\"on_bar\";s:24:\"progressbar_filled_color\";s:7:\"#a0ce4e\";s:31:\"progressbar_filled_border_color\";s:7:\"#ffffff\";s:30:\"progressbar_filled_border_size\";s:1:\"0\";s:26:\"progressbar_unfilled_color\";s:7:\"#f6f6f6\";s:22:\"progressbar_text_color\";s:7:\"#ffffff\";s:23:\"section_sep_border_size\";s:1:\"1\";s:14:\"section_sep_bg\";s:7:\"#f6f6f6\";s:24:\"section_sep_border_color\";s:7:\"#f6f6f6\";s:20:\"separator_style_type\";s:6:\"double\";s:9:\"sep_color\";s:7:\"#e0dede\";s:21:\"separator_border_size\";s:1:\"1\";s:16:\"separator_circle\";s:1:\"1\";s:25:\"separator_circle_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"social_links_font_size\";s:4:\"16px\";s:23:\"social_links_color_type\";s:6:\"custom\";s:23:\"social_links_icon_color\";s:7:\"#bebdbd\";s:18:\"social_links_boxed\";s:1:\"0\";s:22:\"social_links_box_color\";s:7:\"#e8e8e8\";s:25:\"social_links_boxed_radius\";s:3:\"4px\";s:26:\"social_links_boxed_padding\";s:3:\"8px\";s:30:\"social_links_tooltip_placement\";s:3:\"Top\";s:24:\"syntax_highlighter_theme\";s:7:\"default\";s:31:\"syntax_highlighter_line_numbers\";s:3:\"yes\";s:47:\"syntax_highlighter_line_number_background_color\";s:0:\"\";s:41:\"syntax_highlighter_line_number_text_color\";s:0:\"\";s:32:\"syntax_highlighter_line_wrapping\";s:6:\"scroll\";s:36:\"syntax_highlighter_copy_to_clipboard\";s:3:\"yes\";s:41:\"syntax_highlighter_copy_to_clipboard_text\";s:17:\"Copy to Clipboard\";s:28:\"syntax_highlighter_font_size\";s:2:\"14\";s:35:\"syntax_highlighter_background_color\";s:0:\"\";s:30:\"syntax_highlighter_border_size\";s:1:\"1\";s:31:\"syntax_highlighter_border_color\";s:7:\"#e0dede\";s:31:\"syntax_highlighter_border_style\";s:5:\"solid\";s:25:\"syntax_highlighter_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"tabs_bg_color\";s:7:\"#ffffff\";s:19:\"tabs_inactive_color\";s:7:\"#f1f2f2\";s:17:\"tabs_border_color\";s:7:\"#ebeaea\";s:18:\"tabs_icon_position\";s:4:\"left\";s:14:\"tabs_icon_size\";s:2:\"13\";s:10:\"tagline_bg\";s:7:\"#f6f6f6\";s:20:\"tagline_border_color\";s:7:\"#f6f6f6\";s:14:\"tagline_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"84px\";}s:20:\"testimonial_bg_color\";s:7:\"#f6f6f6\";s:22:\"testimonial_text_color\";s:7:\"#747474\";s:18:\"testimonials_speed\";s:4:\"4000\";s:19:\"testimonials_random\";s:1:\"0\";s:12:\"text_columns\";s:1:\"1\";s:21:\"text_column_min_width\";s:5:\"100px\";s:19:\"text_column_spacing\";s:3:\"2em\";s:15:\"text_rule_style\";s:4:\"none\";s:14:\"text_rule_size\";s:1:\"1\";s:15:\"text_rule_color\";s:7:\"#e0dede\";s:16:\"title_style_type\";s:0:\"\";s:18:\"title_border_color\";s:7:\"#e0dede\";s:12:\"title_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"30px\";s:4:\"left\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";}s:19:\"title_margin_mobile\";a:4:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";}s:14:\"accordion_type\";s:10:\"accordions\";s:20:\"accordion_boxed_mode\";s:1:\"0\";s:21:\"accordion_border_size\";s:1:\"1\";s:22:\"accordian_border_color\";s:7:\"#cccccc\";s:26:\"accordian_background_color\";s:7:\"#ffffff\";s:21:\"accordian_hover_color\";s:7:\"#f9f9f9\";s:22:\"accordion_divider_line\";s:1:\"1\";s:25:\"accordion_title_font_size\";s:4:\"14px\";s:19:\"accordion_icon_size\";s:2:\"13\";s:20:\"accordian_icon_color\";s:7:\"#ffffff\";s:20:\"accordion_icon_boxed\";s:1:\"1\";s:24:\"accordian_inactive_color\";s:7:\"#333333\";s:20:\"accordion_icon_align\";s:4:\"left\";s:22:\"accordian_active_color\";s:7:\"#a0ce4e\";s:21:\"user_login_text_align\";s:6:\"center\";s:28:\"user_login_form_field_layout\";s:7:\"stacked\";s:27:\"user_login_form_show_labels\";s:2:\"no\";s:33:\"user_login_form_show_placeholders\";s:3:\"yes\";s:32:\"user_login_form_show_remember_me\";s:2:\"no\";s:32:\"user_login_form_background_color\";s:7:\"#f6f6f6\";s:16:\"visibility_small\";s:3:\"640\";s:17:\"visibility_medium\";s:4:\"1024\";s:22:\"widget_area_title_size\";s:4:\"14px\";s:23:\"widget_area_title_color\";s:7:\"#333333\";s:27:\"searche_grid_column_spacing\";s:2:\"40\";s:11:\"scheme_type\";s:0:\"\";s:12:\"color_scheme\";s:5:\"Green\";s:19:\"reset_caches_button\";s:0:\"\";s:21:\"search_filter_results\";s:1:\"1\";s:14:\"megamenu_width\";s:12:\"custom_width\";s:20:\"button_border_radius\";s:1:\"2\";s:19:\"button_border_color\";s:20:\"rgba(255,255,255,.8)\";s:25:\"button_border_hover_color\";s:20:\"rgba(255,255,255,.9)\";s:21:\"status_css_animations\";s:7:\"desktop\";s:19:\"separator_icon_size\";i:13;s:52:\"blog_element_load_more_posts_hover_button_text_color\";s:4:\"#333\";s:50:\"blog_element_load_more_posts_hover_button_bg_color\";s:21:\"rgba(235,234,234,0.8)\";s:46:\"blog_element_load_more_posts_button_text_color\";s:4:\"#333\";s:44:\"blog_element_load_more_posts_button_bg_color\";s:7:\"#ebeaea\";s:57:\"portfolio_element_load_more_posts_hover_button_text_color\";s:4:\"#333\";s:55:\"portfolio_element_load_more_posts_hover_button_bg_color\";s:21:\"rgba(235,234,234,0.8)\";s:51:\"portfolio_element_load_more_posts_button_text_color\";s:4:\"#333\";s:49:\"portfolio_element_load_more_posts_button_bg_color\";s:7:\"#ebeaea\";s:57:\"portfolio_archive_load_more_posts_hover_button_text_color\";s:4:\"#333\";s:55:\"portfolio_archive_load_more_posts_hover_button_bg_color\";s:21:\"rgba(235,234,234,0.8)\";s:51:\"portfolio_archive_load_more_posts_button_text_color\";s:4:\"#333\";s:44:\"blog_load_more_posts_hover_button_text_color\";s:4:\"#333\";s:42:\"blog_load_more_posts_hover_button_bg_color\";s:21:\"rgba(235,234,234,0.8)\";s:38:\"blog_load_more_posts_button_text_color\";s:4:\"#333\";s:25:\"show_first_featured_image\";s:1:\"1\";s:16:\"icon_color_hover\";s:7:\"#ffffff\";s:23:\"icon_circle_color_hover\";s:7:\"#333333\";s:23:\"icon_border_color_hover\";s:7:\"#333333\";s:21:\"countdown_label_color\";s:7:\"#ffffff\";s:20:\"image_rollover_icons\";s:8:\"linkzoom\";s:17:\"load_block_styles\";s:4:\"auto\";s:13:\"color_palette\";s:71:\"#f44336|#E91E63|#03A9F4|#00BCD4|#8BC34A|#FFEB3B|#FFC107|#FF9800|#607D8B\";s:22:\"main_nav_search_layout\";s:7:\"overlay\";s:31:\"megamenu_interior_content_width\";s:14:\"viewport_width\";s:11:\"woo_sidebar\";s:4:\"None\";s:13:\"woo_sidebar_2\";s:4:\"None\";s:18:\"woo_global_sidebar\";s:1:\"0\";s:20:\"woo_sidebar_position\";s:5:\"Right\";s:27:\"woocommerce_archive_sidebar\";s:4:\"None\";s:29:\"woocommerce_archive_sidebar_2\";s:4:\"None\";s:10:\"ec_sidebar\";s:4:\"None\";s:12:\"ec_sidebar_2\";s:4:\"None\";s:17:\"ec_global_sidebar\";i:0;s:14:\"ec_sidebar_pos\";s:5:\"Right\";s:15:\"ppbress_sidebar\";s:4:\"None\";s:17:\"ppbress_sidebar_2\";s:4:\"None\";s:22:\"bbpress_global_sidebar\";s:1:\"0\";s:24:\"bbpress_sidebar_position\";s:5:\"Right\";s:24:\"excerpt_read_more_symbol\";s:5:\"[...]\";s:23:\"pagination_border_width\";s:1:\"1\";s:23:\"enable_language_updates\";s:1:\"1\";s:34:\"enable_block_editor_backend_styles\";s:1:\"1\";s:27:\"wp_big_image_size_threshold\";s:4:\"2560\";s:12:\"defer_styles\";s:1:\"0\";s:8:\"css_vars\";s:1:\"0\";s:10:\"pwa_enable\";s:1:\"0\";s:25:\"pwa_filetypes_cache_first\";a:4:{i:0;s:6:\"images\";i:1;s:7:\"scripts\";i:2;s:6:\"styles\";i:3;s:5:\"fonts\";}s:27:\"pwa_filetypes_network_first\";a:0:{}s:36:\"pwa_filetypes_stale_while_revalidate\";a:0:{}s:17:\"pwa_manifest_logo\";a:0:{}s:20:\"pwa_manifest_display\";s:10:\"minimal-ui\";s:15:\"pwa_theme_color\";s:16:\"rgb(255,255,255)\";s:24:\"bbp_forum_base_font_size\";s:4:\"12px\";s:19:\"bbp_forum_header_bg\";s:7:\"#ebeaea\";s:27:\"bbp_forum_header_font_color\";s:7:\"#747474\";s:22:\"bbp_forum_border_color\";s:7:\"#ebeaea\";s:9:\"woo_items\";s:2:\"12\";s:29:\"woocommerce_shop_page_columns\";i:4;s:27:\"woocommerce_related_columns\";i:4;s:32:\"woocommerce_archive_page_columns\";i:3;s:19:\"disable_woo_gallery\";s:1:\"1\";s:31:\"woocommerce_single_gallery_size\";s:5:\"500px\";s:37:\"woocommerce_gallery_thumbnail_columns\";i:4;s:23:\"enable_woo_gallery_zoom\";s:1:\"1\";s:29:\"woocommerce_enable_quick_view\";s:1:\"0\";s:26:\"woocommerce_avada_ordering\";s:1:\"1\";s:36:\"woocommerce_disable_crossfade_effect\";s:1:\"1\";s:29:\"woocommerce_one_page_checkout\";s:1:\"0\";s:30:\"woocommerce_enable_order_notes\";s:1:\"1\";s:29:\"woocommerce_acc_link_main_nav\";s:1:\"0\";s:30:\"woocommerce_cart_link_main_nav\";s:1:\"1\";s:24:\"woocommerce_cart_counter\";s:1:\"0\";s:28:\"woocommerce_acc_link_top_nav\";s:1:\"1\";s:29:\"woocommerce_cart_link_top_nav\";s:1:\"1\";s:24:\"woocommerce_social_links\";s:1:\"1\";s:28:\"woocommerce_toggle_grid_list\";s:1:\"1\";s:24:\"woocommerce_product_view\";s:4:\"grid\";s:13:\"woo_acc_msg_1\";s:55:\"Need Assistance? Call customer service at 888-555-5555.\";s:13:\"woo_acc_msg_2\";s:32:\"E-mail them at info@yourshop.com\";s:30:\"woocommerce_product_box_design\";s:7:\"classic\";s:39:\"woocommerce_product_box_content_padding\";a:4:{s:3:\"top\";s:4:\"20px\";s:6:\"bottom\";s:4:\"15px\";s:4:\"left\";s:4:\"15px\";s:5:\"right\";s:4:\"15px\";}s:17:\"product_width_100\";s:1:\"0\";s:25:\"woocommerce_equal_heights\";i:0;s:30:\"woocommerce_product_tab_design\";s:8:\"vertical\";s:12:\"qty_bg_color\";s:7:\"#fbfaf9\";s:18:\"qty_bg_hover_color\";s:7:\"#ffffff\";s:21:\"woo_dropdown_bg_color\";s:7:\"#fbfaf9\";s:23:\"woo_dropdown_text_color\";s:7:\"#333333\";s:25:\"woo_dropdown_border_color\";s:7:\"#dbdbdb\";s:17:\"woo_cart_bg_color\";s:7:\"#fafafa\";s:18:\"woo_icon_font_size\";s:4:\"12px\";s:21:\"ec_display_page_title\";s:5:\"below\";s:26:\"primary_overlay_text_color\";s:7:\"#ffffff\";s:15:\"ec_bar_bg_color\";s:7:\"#efeded\";s:17:\"ec_bar_text_color\";s:7:\"#747474\";s:28:\"ec_calendar_heading_bg_color\";s:7:\"#b2b2b2\";s:20:\"ec_calendar_bg_color\";s:7:\"#b2b2b2\";s:19:\"ec_tooltip_bg_color\";s:7:\"#ffffff\";s:21:\"ec_tooltip_body_color\";s:7:\"#747474\";s:15:\"ec_border_color\";s:7:\"#e0dede\";s:13:\"ec_hover_type\";s:4:\"none\";s:15:\"ec_bg_list_view\";s:5:\"cover\";s:24:\"ec_sep_heading_font_size\";s:4:\"18px\";s:25:\"events_social_sharing_box\";i:1;s:14:\"ec_meta_layout\";s:7:\"sidebar\";s:16:\"ec_sidebar_width\";s:3:\"32%\";s:20:\"ec_sidebar_2_1_width\";s:3:\"21%\";s:20:\"ec_sidebar_2_2_width\";s:3:\"21%\";s:19:\"ec_sidebar_bg_color\";s:7:\"#f6f6f6\";s:18:\"ec_sidebar_padding\";s:2:\"4%\";s:18:\"ec_sidew_font_size\";s:4:\"17px\";s:26:\"ec_sidebar_widget_bg_color\";s:7:\"#aace4e\";s:24:\"ec_sidebar_heading_color\";s:7:\"#333333\";s:17:\"ec_text_font_size\";s:2:\"14\";s:21:\"ec_sidebar_text_color\";s:7:\"#747474\";s:21:\"ec_sidebar_link_color\";s:7:\"#333333\";s:24:\"ec_sidebar_divider_color\";s:7:\"#e8e8e8\";s:15:\"audio_max_width\";s:4:\"100%\";s:22:\"audio_background_color\";s:7:\"#1d242d\";s:23:\"audio_progressbar_color\";s:7:\"#ffffff\";s:27:\"audio_controls_color_scheme\";s:5:\"light\";s:17:\"audio_border_size\";i:0;s:18:\"audio_border_color\";s:0:\"\";s:19:\"audio_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:31:\"full_width_gradient_start_color\";s:19:\"rgba(255,255,255,0)\";s:29:\"full_width_gradient_end_color\";s:19:\"rgba(255,255,255,0)\";s:44:\"container_hundred_percent_scroll_sensitivity\";s:3:\"450\";s:16:\"countdown_layout\";s:7:\"floated\";s:24:\"countdown_label_position\";s:9:\"text_flow\";s:29:\"countdown_counter_box_spacing\";s:4:\"10px\";s:25:\"countdown_counter_padding\";a:4:{s:3:\"top\";s:5:\"0.6em\";s:5:\"right\";s:5:\"1.1em\";s:6:\"bottom\";s:5:\"0.6em\";s:4:\"left\";s:5:\"1.1em\";}s:29:\"countdown_counter_border_size\";s:1:\"0\";s:30:\"countdown_counter_border_color\";s:7:\"#1d242d\";s:31:\"countdown_counter_border_radius\";s:3:\"4px\";s:27:\"countdown_counter_font_size\";s:4:\"18px\";s:25:\"countdown_label_font_size\";s:4:\"18px\";s:27:\"countdown_heading_font_size\";s:4:\"18px\";s:30:\"countdown_subheading_font_size\";s:4:\"14px\";s:18:\"dropcap_text_color\";s:4:\"#fff\";s:9:\"icon_size\";s:2:\"32\";s:11:\"icon_circle\";s:3:\"yes\";s:16:\"icon_border_size\";s:1:\"1\";s:15:\"icon_hover_type\";s:4:\"fade\";s:15:\"video_max_width\";s:4:\"100%\";s:14:\"video_controls\";s:3:\"yes\";s:13:\"video_preload\";s:4:\"auto\";s:24:\"container_legacy_support\";s:1:\"1\";s:23:\"full_width_border_sizes\";a:4:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";}s:20:\"separator_icon_color\";s:0:\"\";s:12:\"sharing_xing\";s:1:\"0\";s:16:\"col_width_medium\";s:3:\"1_1\";s:19:\"status_fusion_forms\";s:1:\"1\";s:33:\"woocommerce_product_images_layout\";s:5:\"avada\";s:31:\"woocommerce_product_images_zoom\";s:1:\"1\";s:35:\"woocommerce_gallery_thumbnail_width\";i:100;s:39:\"woocommerce_archive_grid_column_spacing\";s:2:\"20\";s:13:\"preload_fonts\";s:4:\"none\";s:14:\"social_sharing\";a:6:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:6:\"reddit\";i:3;s:8:\"linkedin\";i:4;s:9:\"pinterest\";i:5;s:2:\"vk\";}}", "yes");
INSERT INTO `wp_options` VALUES("324", "fusion_options-transients", "a:2:{s:14:\"changed_values\";a:2:{s:18:\"social_media_icons\";a:5:{s:25:\"fusionredux_repeater_data\";a:6:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}i:5;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"icon\";a:6:{i:0;s:8:\"facebook\";i:1;s:5:\"gplus\";i:2;s:9:\"instagram\";i:3;s:8:\"linkedin\";i:4;s:3:\"rss\";i:5;s:8:\"whatsapp\";}s:3:\"url\";a:6:{i:0;s:1:\"#\";i:1;s:1:\"#\";i:2;s:1:\"#\";i:3;s:1:\"#\";i:4;s:1:\"#\";i:5;s:1:\"#\";}s:12:\"custom_title\";a:6:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:13:\"custom_source\";a:6:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:3;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:4;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:5;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:11:\"search_meta\";a:6:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:9:\"read_more\";i:5;s:4:\"tags\";}}s:9:\"last_save\";i:1591684043;}", "yes");
INSERT INTO `wp_options` VALUES("279", "sbg_sidebars", "a:9:{s:14:\"ContactSidebar\";s:15:\"Contact Sidebar\";s:3:\"FAQ\";s:3:\"FAQ\";s:15:\"HomepageSidebar\";s:17:\"Home Page Sidebar\";s:9:\"Portfolio\";s:9:\"Portfolio\";s:9:\"Megamenu1\";s:9:\"Megamenu1\";s:9:\"Megamenu2\";s:9:\"Megamenu2\";s:7:\"Twitter\";s:7:\"Twitter\";s:11:\"PageWidget1\";s:13:\"Page Widget 1\";s:11:\"PageWidget2\";s:13:\"Page Widget 2\";}", "yes");
INSERT INTO `wp_options` VALUES("6293", "fusion_registration_data", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6294", "avada_page_options", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6515", "bsf_local_transient", "1622920932", "yes");
INSERT INTO `wp_options` VALUES("6518", "bsf-updater-version", "1.27.14", "yes");
INSERT INTO `wp_options` VALUES("6519", "brainstrom_products", "a:1:{s:7:\"plugins\";a:1:{i:14058953;a:19:{s:8:\"template\";s:27:\"convertplug/convertplug.php\";s:6:\"remote\";s:6:\"3.5.20\";s:7:\"version\";s:6:\"3.5.18\";s:12:\"purchase_key\";s:0:\"\";s:6:\"status\";s:14:\"not-registered\";s:7:\"message\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:8:\"14058953\";s:12:\"product_name\";s:12:\"Convert Plus\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:4:\"true\";s:15:\"is_product_free\";s:5:\"false\";s:10:\"short_name\";s:0:\"\";s:13:\"changelog_url\";s:43:\"https://www.convertplug.com/plus/changelog/\";s:12:\"purchase_url\";s:75:\"https://codecanyon.net/cart/add_items?item_ids=14058953&ref=BrainstormForce\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:12:\"download_url\";s:0:\"\";s:6:\"tested\";s:5:\"5.7.2\";}}}", "yes");
INSERT INTO `wp_options` VALUES("9303", "bsf_skip_author", "", "no");
INSERT INTO `wp_options` VALUES("6523", "bsf_local_transient_bundled", "1622920951", "yes");
INSERT INTO `wp_options` VALUES("6528", "bsf_skip_braisntorm_menu", "", "no");
INSERT INTO `wp_options` VALUES("6529", "smile_lists", "a:1:{i:0;a:5:{s:4:\"date\";s:10:\"12-02-2020\";s:9:\"list-name\";s:5:\"First\";s:13:\"list-provider\";s:12:\"Convert Plug\";s:4:\"list\";s:0:\"\";s:13:\"provider_list\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("6526", "brainstrom_bundled_products", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("11358", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:1;s:3:\"all\";i:1;s:8:\"approved\";s:1:\"1\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("11359", "_transient_as_comment_count", "O:8:\"stdClass\":7:{s:8:\"approved\";s:1:\"1\";s:14:\"total_comments\";i:1;s:3:\"all\";i:1;s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("6530", "convert_plug_settings", "a:28:{s:19:\"cp-enable-mx-record\";s:1:\"0\";s:19:\"cp-default-messages\";s:1:\"1\";s:21:\"cp-already-subscribed\";s:22:\"Already Subscribed...!\";s:15:\"cp-double-optin\";s:1:\"1\";s:13:\"cp-gdpr-optin\";s:1:\"1\";s:13:\"cp-sub-notify\";s:1:\"0\";s:12:\"cp-sub-email\";s:16:\"prajaktag@bsf.io\";s:12:\"cp-email-sub\";s:43:\"Congratulations! You have a New Subscriber!\";s:15:\"cp-google-fonts\";s:1:\"1\";s:11:\"cp-timezone\";s:9:\"wordpress\";s:15:\"user_inactivity\";s:2:\"60\";s:18:\"cp-edit-style-link\";s:1:\"0\";s:17:\"cp-plugin-support\";s:1:\"0\";s:21:\"cp-disable-impression\";s:1:\"0\";s:15:\"cp-close-inline\";s:1:\"0\";s:18:\"cp-disable-storage\";s:1:\"0\";s:14:\"cp-disable-pot\";s:1:\"1\";s:17:\"cp-disable-domain\";s:1:\"0\";s:14:\"cp-domain-name\";s:0:\"\";s:11:\"cp-lazy-img\";s:1:\"0\";s:16:\"cp-close-gravity\";s:1:\"1\";s:11:\"cp-load-syn\";s:1:\"0\";s:16:\"cp_change_ntf_id\";s:1:\"1\";s:18:\"cp_notify_email_to\";s:16:\"prajaktag@bsf.io\";s:14:\"cp-access-role\";s:0:\"\";s:12:\"cp-user-role\";s:13:\"administrator\";s:16:\"cp-new-user-role\";s:0:\"\";s:13:\"cp-email-body\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("6543", "acf_version", "5.8.5", "yes");
INSERT INTO `wp_options` VALUES("6544", "bsf_installer_menu", "a:1:{s:11:\"ConvertPlus\";a:4:{s:11:\"parent_slug\";s:12:\"convert-plus\";s:10:\"page_title\";s:6:\"Addons\";s:10:\"menu_title\";s:6:\"Addons\";s:10:\"product_id\";s:8:\"14058953\";}}", "no");
INSERT INTO `wp_options` VALUES("7095", "revslider-deact-notice", "1", "yes");
INSERT INTO `wp_options` VALUES("8529", "rs-templates", "a:3:{s:4:\"hash\";s:32:\"b34e16da992470421084a8b82c104a98\";s:6:\"slider\";a:507:{i:0;a:22:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:22:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:22:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:22:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:22:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:22:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:413:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:22:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:22:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:22:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:22:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:22:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:22:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:22:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:22:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:22:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:22:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:22:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:22:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:22:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:22:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:22:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:22:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:22:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:22:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:22:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:22:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:22:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:22:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:22:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:22:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:22:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:22:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:22:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:22:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:22:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:22:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:22:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:22:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:22:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:22:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:495:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:22:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:22:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:22:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:22:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:22:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:22:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:22:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:22:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:22:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:22:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:22:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:22:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:22:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:22:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:22:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:22:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:22:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:22:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:22:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:22:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:22:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:22:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:22:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:22:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:22:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:22:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:22:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:25:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:25:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:25:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:25:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:25:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:25:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:25:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:25:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:25:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:25:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:25:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:25:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:25:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:25:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:25:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:25:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:22:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:22:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:22:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:22:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:25:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:25:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:25:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:25:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:25:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:25:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:25:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:25:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:22:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:22:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:25:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:25:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:25:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:25:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:25:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:22:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:22:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:22:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:25:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:25:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:25:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:25:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:22:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:22:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:25:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:25:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:25:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:25:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:25:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:25:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:117;a:25:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:118;a:25:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:119;a:25:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:120;a:25:{s:2:\"id\";s:3:\"122\";s:5:\"title\";s:20:\"Themeplicity Package\";s:5:\"alias\";s:20:\"themeplicity-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:20:\"themeplicity-package\";s:3:\"img\";s:38:\"packages/templatepack_themeplicity.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:121;a:25:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:122;a:25:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:123;a:25:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:124;a:25:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:125;a:25:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:126;a:25:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:127;a:25:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:128;a:25:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:129;a:25:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:130;a:25:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:542:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:131;a:22:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/80s-style-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:317:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:22:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/blur-effect-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:22:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/coming-soon-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:134;a:25:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Nice And Clean Package\";s:5:\"alias\";s:22:\"nice-and-clean-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"nice-and-clean-package\";s:3:\"img\";s:38:\"packages/templatepack_niceandclean.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:242:\"<span class=\"ttm_content\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:135;a:22:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/snow-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:22:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/particle-effect-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:442:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:22:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/particle-effect-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:22:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/particle-background-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:22:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:387:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:140;a:22:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:22:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:142;a:22:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/404-error-page-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"{\"1\":{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}}\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:143;a:22:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-carousel-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:22:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s:3:\"uid\";s:32:\"7bd142f272cc15d86998a79520e9e581\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/filmstrip-add-on-slider/ \";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\r\n There is lots of customization options like animation speed and direction.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:180:\"[{\"path\":\"revslider-filmstrip-addon\\/revslider-filmstrip-addon.php\",\"name\":\"Background FilmStrip Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:145;a:22:{s:2:\"id\";s:3:\"148\";s:5:\"title\";s:11:\"Space Opera\";s:5:\"alias\";s:10:\"spaceopera\";s:3:\"zip\";s:14:\"spaceopera.zip\";s:3:\"uid\";s:32:\"a2c8bffcb138a86c0f373adebb6de046\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/space-opera-presentation/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:146;a:22:{s:2:\"id\";s:3:\"149\";s:5:\"title\";s:13:\"Website Intro\";s:5:\"alias\";s:12:\"websiteintro\";s:3:\"zip\";s:16:\"websiteintro.zip\";s:3:\"uid\";s:32:\"348df76d999456aa19be58c9df56ae20\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/website-intro-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:274:\"<span class=\"ttm_content\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:147;a:22:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:13:\"Mask Showcase\";s:5:\"alias\";s:12:\"maskshowcase\";s:3:\"zip\";s:16:\"maskshowcase.zip\";s:3:\"uid\";s:32:\"fc943c31e2da9c63b252aeabf554d128\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/minimal-mask-showcase/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:148;a:22:{s:2:\"id\";s:3:\"151\";s:5:\"title\";s:20:\"Parallax Zoom Slices\";s:5:\"alias\";s:18:\"parallaxzoomslices\";s:3:\"zip\";s:22:\"parallaxzoomslices.zip\";s:3:\"uid\";s:32:\"83537cae05709ddb9bcb7375470a5894\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/parallax-zoom-slices-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:149;a:22:{s:2:\"id\";s:3:\"152\";s:5:\"title\";s:22:\"Double Exposure Effect\";s:5:\"alias\";s:20:\"doubleexposureeffect\";s:3:\"zip\";s:24:\"doubleexposureeffect.zip\";s:3:\"uid\";s:32:\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/wordpress-double-exposure-effect/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:150;a:22:{s:2:\"id\";s:3:\"153\";s:5:\"title\";s:24:\"Mountain Parallax Header\";s:5:\"alias\";s:22:\"mountainparallaxheader\";s:3:\"zip\";s:26:\"mountainparallaxheader.zip\";s:3:\"uid\";s:32:\"8dc64663f317a2abdf179bbe341d016e\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/mountain-wordpress-parallax-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:192:\"<span class=\"ttm_content\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:151;a:25:{s:2:\"id\";s:3:\"154\";s:5:\"title\";s:26:\"GoodNews One-Pager Package\";s:5:\"alias\";s:26:\"goodnews-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"goodnews-one-pager-package\";s:3:\"img\";s:44:\"packages/templatepack_goodnews_one_pager.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:4:{i:0;s:8:\"carousel\";i:1;s:6:\"slider\";i:2;s:4:\"hero\";i:3;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:152;a:25:{s:2:\"id\";s:3:\"155\";s:5:\"title\";s:13:\"GoodNews Menu\";s:5:\"alias\";s:12:\"goodnewsmenu\";s:3:\"zip\";s:22:\"packs/goodnewsmenu.zip\";s:3:\"uid\";s:32:\"4cbc82501ff340fcdc0acf7eb3ba2640\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:153;a:25:{s:2:\"id\";s:3:\"156\";s:5:\"title\";s:15:\"GoodNews Header\";s:5:\"alias\";s:14:\"goodnewsheader\";s:3:\"zip\";s:24:\"packs/goodnewsheader.zip\";s:3:\"uid\";s:32:\"c6660b6bdbf596f38466f569596f5259\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:154;a:25:{s:2:\"id\";s:3:\"157\";s:5:\"title\";s:18:\"GoodNews Whats Hot\";s:5:\"alias\";s:16:\"goodnewswhatshot\";s:3:\"zip\";s:26:\"packs/goodnewswhatshot.zip\";s:3:\"uid\";s:32:\"cb841ce64a99a6644adab049cf5405cd\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:155;a:25:{s:2:\"id\";s:3:\"158\";s:5:\"title\";s:17:\"GoodNews Featured\";s:5:\"alias\";s:16:\"goodnewsfeatured\";s:3:\"zip\";s:26:\"packs/goodnewsfeatured.zip\";s:3:\"uid\";s:32:\"00bde4b09e3700da7183999eaf137ccc\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:156;a:25:{s:2:\"id\";s:3:\"159\";s:5:\"title\";s:18:\"GoodNews Spotlight\";s:5:\"alias\";s:17:\"goodnewsspotlight\";s:3:\"zip\";s:27:\"packs/goodnewsspotlight.zip\";s:3:\"uid\";s:32:\"138076241a828e1c5764379944755f2b\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.4\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:157;a:25:{s:2:\"id\";s:3:\"160\";s:5:\"title\";s:17:\"GoodNews Carousel\";s:5:\"alias\";s:16:\"goodnewscarousel\";s:3:\"zip\";s:26:\"packs/goodnewscarousel.zip\";s:3:\"uid\";s:32:\"d29d4460a6015e30d08d2714232d3768\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:158;a:25:{s:2:\"id\";s:3:\"161\";s:5:\"title\";s:16:\"GoodNews Callout\";s:5:\"alias\";s:15:\"goodnewscallout\";s:3:\"zip\";s:25:\"packs/goodnewscallout.zip\";s:3:\"uid\";s:32:\"d9568b3193e96577fae630b3a6728785\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:159;a:25:{s:2:\"id\";s:3:\"162\";s:5:\"title\";s:15:\"GoodNews Footer\";s:5:\"alias\";s:14:\"goodnewsfooter\";s:3:\"zip\";s:24:\"packs/goodnewsfooter.zip\";s:3:\"uid\";s:32:\"34f43f891cb8d55375149dc4bbc38298\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:160;a:25:{s:2:\"id\";s:3:\"163\";s:5:\"title\";s:29:\"GoodNews Content Page Package\";s:5:\"alias\";s:29:\"goodnews-content-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:29:\"goodnews-content-page-package\";s:3:\"img\";s:55:\"packages/templatepack_goodnews_content_page_package.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:161;a:25:{s:2:\"id\";s:3:\"164\";s:5:\"title\";s:18:\"GoodNews Menu Back\";s:5:\"alias\";s:16:\"goodnewsmenuback\";s:3:\"zip\";s:26:\"packs/goodnewsmenuback.zip\";s:3:\"uid\";s:32:\"1340d1aeefba497a7d404d12a1fceed4\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:162;a:25:{s:2:\"id\";s:3:\"165\";s:5:\"title\";s:20:\"GoodNews Blog Header\";s:5:\"alias\";s:18:\"goodnewsblogheader\";s:3:\"zip\";s:28:\"packs/goodnewsblogheader.zip\";s:3:\"uid\";s:32:\"abc4d7c1e48475c6def05f1f6d8bf564\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:163;a:25:{s:2:\"id\";s:3:\"166\";s:5:\"title\";s:21:\"GoodNews Blog Content\";s:5:\"alias\";s:19:\"goodnewsblogcontent\";s:3:\"zip\";s:29:\"packs/goodnewsblogcontent.zip\";s:3:\"uid\";s:32:\"bbf34563da6db2779c29599b503b07e9\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:164;a:25:{s:2:\"id\";s:3:\"167\";s:5:\"title\";s:21:\"GoodNews Testimonials\";s:5:\"alias\";s:20:\"goodnewstestimonials\";s:3:\"zip\";s:30:\"packs/goodnewstestimonials.zip\";s:3:\"uid\";s:32:\"606b7336e86f69c567542d3f43712b56\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:165;a:25:{s:2:\"id\";s:3:\"168\";s:5:\"title\";s:20:\"GoodNews Blog Footer\";s:5:\"alias\";s:18:\"goodnewsblogfooter\";s:3:\"zip\";s:28:\"packs/goodnewsblogfooter.zip\";s:3:\"uid\";s:32:\"1fb88aecfb116fde67ce8d52bd3b5f05\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:166;a:22:{s:2:\"id\";s:3:\"169\";s:5:\"title\";s:19:\"Before After Slider\";s:5:\"alias\";s:17:\"beforeafterslider\";s:3:\"zip\";s:21:\"beforeafterslider.zip\";s:3:\"uid\";s:32:\"6e615091a1fc3037c24b985ce5136fb2\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/before-after-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.3.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">This is the example slider for our Before / After Add-On that allows you to create unique presentations with a comparing functionality.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:167;a:22:{s:2:\"id\";s:3:\"170\";s:5:\"title\";s:16:\"Product Showcase\";s:5:\"alias\";s:15:\"productshowcase\";s:3:\"zip\";s:19:\"productshowcase.zip\";s:3:\"uid\";s:32:\"a43447670260aaa7e8ff66cedfddb57a\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/wordpress-product-showcase-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:165:\"<span class=\"ttm_content\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:168;a:22:{s:2:\"id\";s:3:\"171\";s:5:\"title\";s:23:\"Overexposure Transition\";s:5:\"alias\";s:22:\"overexposuretransition\";s:3:\"zip\";s:26:\"overexposuretransition.zip\";s:3:\"uid\";s:32:\"13f16bbe6c6d646c7d0cb817a0d3d181\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/overexposure-transition-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:169;a:22:{s:2:\"id\";s:3:\"172\";s:5:\"title\";s:15:\"Parallax Scroll\";s:5:\"alias\";s:14:\"parallaxscroll\";s:3:\"zip\";s:18:\"parallaxscroll.zip\";s:3:\"uid\";s:32:\"82546ee2f6af6c6682852f495109b3c3\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/parallax-scroll/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A strikingly colourful header for your website with super smooth parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:170;a:25:{s:2:\"id\";s:3:\"173\";s:5:\"title\";s:24:\"TechCo One-Pager Package\";s:5:\"alias\";s:24:\"techco-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:24:\"techco-one-pager-package\";s:3:\"img\";s:28:\"packages/techco_overview.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:171;a:25:{s:2:\"id\";s:3:\"174\";s:5:\"title\";s:11:\"TechCo Menu\";s:5:\"alias\";s:11:\"techco-menu\";s:3:\"zip\";s:21:\"packs/techco-menu.zip\";s:3:\"uid\";s:32:\"55e5efee828cdf1ff7e2d3b90a301ea9\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:172;a:25:{s:2:\"id\";s:3:\"175\";s:5:\"title\";s:13:\"TechCo Header\";s:5:\"alias\";s:13:\"techco-header\";s:3:\"zip\";s:23:\"packs/techco-header.zip\";s:3:\"uid\";s:32:\"fb574d1376de9b1e408c91f51e6497d7\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:173;a:25:{s:2:\"id\";s:3:\"176\";s:5:\"title\";s:12:\"TechCo About\";s:5:\"alias\";s:12:\"techco-about\";s:3:\"zip\";s:22:\"packs/techco-about.zip\";s:3:\"uid\";s:32:\"ba216da8231e55118d87e37d2358812c\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:174;a:25:{s:2:\"id\";s:3:\"177\";s:5:\"title\";s:15:\"TechCo Services\";s:5:\"alias\";s:15:\"techco-services\";s:3:\"zip\";s:25:\"packs/techco-services.zip\";s:3:\"uid\";s:32:\"ef4a8ddbb5e1136133f7bc1227248e22\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:175;a:25:{s:2:\"id\";s:3:\"178\";s:5:\"title\";s:12:\"TechCo Video\";s:5:\"alias\";s:12:\"techco-video\";s:3:\"zip\";s:22:\"packs/techco-video.zip\";s:3:\"uid\";s:32:\"d7bb92281d05f39f9bc9eca71f90e402\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:176;a:25:{s:2:\"id\";s:3:\"179\";s:5:\"title\";s:13:\"TechCo Prices\";s:5:\"alias\";s:13:\"techco-prices\";s:3:\"zip\";s:23:\"packs/techco-prices.zip\";s:3:\"uid\";s:32:\"6291f404efbea12bb181352aba71ef11\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:177;a:25:{s:2:\"id\";s:3:\"180\";s:5:\"title\";s:19:\"TechCo Testimonials\";s:5:\"alias\";s:19:\"techco-testimonials\";s:3:\"zip\";s:29:\"packs/techco-testimonials.zip\";s:3:\"uid\";s:32:\"3460bd51f6b80599266fecb7fbb918be\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:178;a:25:{s:2:\"id\";s:3:\"181\";s:5:\"title\";s:13:\"TechCo Footer\";s:5:\"alias\";s:13:\"techco-footer\";s:3:\"zip\";s:23:\"packs/techco-footer.zip\";s:3:\"uid\";s:32:\"640abcd549137520461a4a71ff758a3b\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:179;a:22:{s:2:\"id\";s:3:\"182\";s:5:\"title\";s:12:\"Live Weather\";s:5:\"alias\";s:7:\"weather\";s:3:\"zip\";s:11:\"weather.zip\";s:3:\"uid\";s:32:\"aab92e69374e4c7b8c6741fe02e574b9\";s:3:\"img\";s:18:\"weather/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-live-weather-add-on/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:168:\"[{\"path\":\"revslider-weather-addon\\/revslider-weather-addon.php\",\"name\":\"Live Weather Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:180;a:22:{s:2:\"id\";s:3:\"183\";s:5:\"title\";s:17:\"360 Panorama Tour\";s:5:\"alias\";s:11:\"360panorama\";s:3:\"zip\";s:15:\"360panorama.zip\";s:3:\"uid\";s:32:\"332720fdacdbb38f65e8327a2a96c52d\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/360-degree-real-estate-virtual-tour/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">An example template for our Panorama 360 tour add-on, created for the real estate market.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:165:\"[{\"path\":\"revslider-panorama-addon\\/revslider-panorama-addon.php\",\"name\":\"Panorama AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:181;a:22:{s:2:\"id\";s:3:\"184\";s:5:\"title\";s:14:\"Duotone Add-on\";s:5:\"alias\";s:14:\"duotone-add-on\";s:3:\"zip\";s:18:\"duotone-add-on.zip\";s:3:\"uid\";s:32:\"a428c6f363b3146e96d20a6f44958922\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-duotone-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:168:\"<span class=\"ttm_content\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:350:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-duotonefilters-addon\\/revslider-duotonefilters-addon.php\",\"name\":\"Duotone AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:182;a:22:{s:2:\"id\";s:3:\"185\";s:5:\"title\";s:13:\"Reveal Add-on\";s:5:\"alias\";s:13:\"reveal-add-on\";s:3:\"zip\";s:17:\"reveal-add-on.zip\";s:3:\"uid\";s:32:\"7fa7525d8ff7fa7365cb98a437e88e32\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-content-reveal-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:337:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:201;a:22:{s:2:\"id\";s:3:\"210\";s:5:\"title\";s:21:\"Cryptocurrency Prices\";s:5:\"alias\";s:12:\"cryptoslider\";s:3:\"zip\";s:16:\"cryptoslider.zip\";s:3:\"uid\";s:32:\"c4b02210387f11946223977e940d9e9e\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";s:7:\"preview\";s:95:\"https://revolution.themepunch.com/cryptocurrency-wordpress-price-api-bitcoin-ethereum-litecoin/\";s:7:\"version\";s:5:\"1.0.6\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:209:\"<span class=\"ttm_content\">This Template can show live, animated cryptocurrency prices. More than 1300 currencies are supported, getting prices via the cryptocompare API.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:410:\"<span class=\"ttm_content\">Please refer to the \"Custom JavaScript\" section of this sliders settings, for info on how to modify currencies. Provide a class to the row / column / group where the currency text elements are located in.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:202;a:25:{s:2:\"id\";s:3:\"211\";s:5:\"title\";s:18:\"Immersion One Page\";s:5:\"alias\";s:26:\"immersion-one-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"immersion-one-page-package\";s:3:\"img\";s:31:\"packages/immersion_overview.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:343:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:203;a:25:{s:2:\"id\";s:3:\"212\";s:5:\"title\";s:16:\"Immersion Header\";s:5:\"alias\";s:16:\"immersion_header\";s:3:\"zip\";s:26:\"packs/immersion_header.zip\";s:3:\"uid\";s:32:\"853da51256308b341ecd030bd4883229\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:204;a:25:{s:2:\"id\";s:3:\"213\";s:5:\"title\";s:19:\"Immersion Mountains\";s:5:\"alias\";s:19:\"immersion-mountains\";s:3:\"zip\";s:29:\"packs/immersion-mountains.zip\";s:3:\"uid\";s:32:\"817167eb3fe22b7e065ba210cbe6d53c\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:205;a:25:{s:2:\"id\";s:3:\"214\";s:5:\"title\";s:17:\"Immersion Product\";s:5:\"alias\";s:17:\"immersion-product\";s:3:\"zip\";s:27:\"packs/immersion-product.zip\";s:3:\"uid\";s:32:\"64134f263484d2bbcd7ef088ffbbfb4b\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:206;a:25:{s:2:\"id\";s:3:\"215\";s:5:\"title\";s:16:\"Immersion Design\";s:5:\"alias\";s:16:\"immersion-design\";s:3:\"zip\";s:26:\"packs/immersion-design.zip\";s:3:\"uid\";s:32:\"91e1d77c1a2826438763804f4d02bc26\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:207;a:25:{s:2:\"id\";s:3:\"216\";s:5:\"title\";s:22:\"Immersion Phototgraphy\";s:5:\"alias\";s:21:\"immersion-photography\";s:3:\"zip\";s:31:\"packs/immersion-photography.zip\";s:3:\"uid\";s:32:\"e3ddf0c577b09740f5cbf2e38ffd684d\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:208;a:25:{s:2:\"id\";s:3:\"217\";s:5:\"title\";s:14:\"Immersion Grid\";s:5:\"alias\";s:14:\"immersion-grid\";s:3:\"zip\";s:24:\"packs/immersion-grid.zip\";s:3:\"uid\";s:32:\"b6903868189bb83b2c7a852fde3a7dc3\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:209;a:22:{s:2:\"id\";s:3:\"218\";s:5:\"title\";s:18:\"Funky Intro Slider\";s:5:\"alias\";s:11:\"funkyslider\";s:3:\"zip\";s:15:\"funkyslider.zip\";s:3:\"uid\";s:32:\"2d4187e3fdad19b976be335253c8925d\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/funky-intro-slider-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:335:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:210;a:25:{s:2:\"id\";s:3:\"219\";s:5:\"title\";s:19:\"Clear View Magazine\";s:5:\"alias\";s:27:\"clear-view-magazine-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"clear-view-magazine-package\";s:3:\"img\";s:41:\"packages/clear_view_magazine_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:211;a:25:{s:2:\"id\";s:3:\"220\";s:5:\"title\";s:15:\"Clear View Menu\";s:5:\"alias\";s:14:\"clearview_menu\";s:3:\"zip\";s:24:\"packs/clearview_menu.zip\";s:3:\"uid\";s:32:\"eaecee5fa5f3c3a7f4d2a96c4616a353\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:212;a:25:{s:2:\"id\";s:3:\"221\";s:5:\"title\";s:17:\"Clear View Header\";s:5:\"alias\";s:16:\"clearview_header\";s:3:\"zip\";s:26:\"packs/clearview_header.zip\";s:3:\"uid\";s:32:\"25e3dd80ad130875d7438a07952cb0cd\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:213;a:25:{s:2:\"id\";s:3:\"222\";s:5:\"title\";s:18:\"Clear View Mission\";s:5:\"alias\";s:17:\"clearview_mission\";s:3:\"zip\";s:27:\"packs/clearview_mission.zip\";s:3:\"uid\";s:32:\"35b2092a49fd2beb549342e69097eb5b\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:214;a:25:{s:2:\"id\";s:3:\"223\";s:5:\"title\";s:17:\"Clear View Slider\";s:5:\"alias\";s:17:\"clear-view-slider\";s:3:\"zip\";s:27:\"packs/clear-view-slider.zip\";s:3:\"uid\";s:32:\"d2e17edffce16ed78c54b0ef23fd7e05\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:215;a:25:{s:2:\"id\";s:3:\"224\";s:5:\"title\";s:15:\"Clear View News\";s:5:\"alias\";s:15:\"clear-view-news\";s:3:\"zip\";s:25:\"packs/clear-view-news.zip\";s:3:\"uid\";s:32:\"5698d3131ba141e9afcfd2906739dd00\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:216;a:25:{s:2:\"id\";s:3:\"225\";s:5:\"title\";s:18:\"Clear View Clients\";s:5:\"alias\";s:18:\"clear-view-clients\";s:3:\"zip\";s:28:\"packs/clear-view-clients.zip\";s:3:\"uid\";s:32:\"b95616a94832e22bdfac5ce60232be1b\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:217;a:25:{s:2:\"id\";s:3:\"226\";s:5:\"title\";s:18:\"Clear View Contact\";s:5:\"alias\";s:18:\"clear-view-contact\";s:3:\"zip\";s:28:\"packs/clear-view-contact.zip\";s:3:\"uid\";s:32:\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:218;a:25:{s:2:\"id\";s:3:\"227\";s:5:\"title\";s:20:\"Clear View Post Page\";s:5:\"alias\";s:28:\"clear-view-post-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"clear-view-post-page-package\";s:3:\"img\";s:42:\"packages/clear_view_post_page_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:219;a:25:{s:2:\"id\";s:3:\"228\";s:5:\"title\";s:22:\"Clear View Single Menu\";s:5:\"alias\";s:22:\"clear-view-single-menu\";s:3:\"zip\";s:32:\"packs/clear-view-single-menu.zip\";s:3:\"uid\";s:32:\"1e80f81982f8a4ea763482d4fa99d321\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:220;a:25:{s:2:\"id\";s:3:\"229\";s:5:\"title\";s:24:\"Clear View Single Header\";s:5:\"alias\";s:24:\"clear-view-single-header\";s:3:\"zip\";s:34:\"packs/clear-view-single-header.zip\";s:3:\"uid\";s:32:\"c8d717627be6cd5e70922ab609694dbf\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:221;a:25:{s:2:\"id\";s:3:\"230\";s:5:\"title\";s:23:\"Clear View Single Media\";s:5:\"alias\";s:23:\"clear-view-single-media\";s:3:\"zip\";s:33:\"packs/clear-view-single-media.zip\";s:3:\"uid\";s:32:\"c480368ded2a64f0cdd44f1674213814\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:222;a:25:{s:2:\"id\";s:3:\"231\";s:5:\"title\";s:22:\"Clear View Single More\";s:5:\"alias\";s:22:\"clear-view-single-more\";s:3:\"zip\";s:32:\"packs/clear-view-single-more.zip\";s:3:\"uid\";s:32:\"9c693190df26218366d1f77e10cf550a\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:223;a:25:{s:2:\"id\";s:3:\"232\";s:5:\"title\";s:25:\"Clear View Single Contact\";s:5:\"alias\";s:25:\"clear-view-single-contact\";s:3:\"zip\";s:35:\"packs/clear-view-single-contact.zip\";s:3:\"uid\";s:32:\"73c0a889f2b654a87b5aba1ff76fbc5c\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:224;a:22:{s:2:\"id\";s:3:\"233\";s:5:\"title\";s:18:\"Clean Landing Page\";s:5:\"alias\";s:16:\"cleanlandingpage\";s:3:\"zip\";s:20:\"cleanlandingpage.zip\";s:3:\"uid\";s:32:\"727a3680d312f22c6a5998ebdb9afe52\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/clean-landing-page-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:203:\"<span class=\"ttm_content\">The Clean Landing Page is a fullscreen Intro Module that is a striking introduction to any minimal website, with no unnecessary elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:225;a:22:{s:2:\"id\";s:3:\"234\";s:5:\"title\";s:9:\"Clear Cut\";s:5:\"alias\";s:8:\"clearcut\";s:3:\"zip\";s:12:\"clearcut.zip\";s:3:\"uid\";s:32:\"07f43c00e9b4d3057a03cdb3385ad2b7\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/clear-cut-portfolio-website-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:240:\"<span class=\"ttm_content\">The Clear Cut Template is an All-In-One Portfolio Website solution that works best for smaller portfolios. Highlight your best work in a striking and mobile friendly fashion!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:226;a:25:{s:2:\"id\";s:3:\"235\";s:5:\"title\";s:22:\"Wonderstruck One-Pager\";s:5:\"alias\";s:30:\"wonderstruck-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:30:\"wonderstruck-one-pager-package\";s:3:\"img\";s:44:\"packages/wonderstruck-one-pager-overview.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:227;a:25:{s:2:\"id\";s:3:\"236\";s:5:\"title\";s:17:\"Wonderstruck Menu\";s:5:\"alias\";s:17:\"wonderstruck_menu\";s:3:\"zip\";s:27:\"packs/wonderstruck_menu.zip\";s:3:\"uid\";s:32:\"0a976e9aaae59c4f795b38f59f5a08d8\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:228;a:25:{s:2:\"id\";s:3:\"237\";s:5:\"title\";s:19:\"Wonderstruck Header\";s:5:\"alias\";s:19:\"wonderstruck_header\";s:3:\"zip\";s:29:\"packs/wonderstruck_header.zip\";s:3:\"uid\";s:32:\"e1379f77a902960a0ce12d44d85a9e0a\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:229;a:25:{s:2:\"id\";s:3:\"238\";s:5:\"title\";s:18:\"Wonderstruck About\";s:5:\"alias\";s:18:\"wonderstruck_about\";s:3:\"zip\";s:28:\"packs/wonderstruck_about.zip\";s:3:\"uid\";s:32:\"d207fb140fd328acc3038300ea52082a\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:230;a:25:{s:2:\"id\";s:3:\"239\";s:5:\"title\";s:18:\"Wonderstruck Works\";s:5:\"alias\";s:18:\"wonderstruck-works\";s:3:\"zip\";s:28:\"packs/wonderstruck-works.zip\";s:3:\"uid\";s:32:\"4476935097e27d92454b0011b7700c1d\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:231;a:25:{s:2:\"id\";s:3:\"240\";s:5:\"title\";s:20:\"Wonderstruck Contact\";s:5:\"alias\";s:20:\"wonderstruck-contact\";s:3:\"zip\";s:30:\"packs/wonderstruck-contact.zip\";s:3:\"uid\";s:32:\"9e4911521f77bce2b8efa40f4c2adc22\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:232;a:22:{s:2:\"id\";s:3:\"241\";s:5:\"title\";s:12:\"Bubble Morph\";s:5:\"alias\";s:11:\"bubblemorph\";s:3:\"zip\";s:15:\"bubblemorph.zip\";s:3:\"uid\";s:32:\"1102d6f5460ab82cb612cbe9f1d9514b\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";s:7:\"preview\";s:75:\"https://revolution.themepunch.com/bubble-morph-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:188:\"<span class=\"ttm_content\">The Bubble Morph Add-On allows you to create interesting Lava-Lamp style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:233;a:22:{s:2:\"id\";s:3:\"242\";s:5:\"title\";s:16:\"Distortion AddOn\";s:5:\"alias\";s:15:\"distortionaddon\";s:3:\"zip\";s:19:\"distortionaddon.zip\";s:3:\"uid\";s:32:\"0ad46c9929bb2fa6316f1e6ced301aaf\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/distortion-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Distortion Add-On allows you to create interesting Distortion style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:234;a:22:{s:2:\"id\";s:3:\"243\";s:5:\"title\";s:10:\"Club Flyer\";s:5:\"alias\";s:9:\"clubflyer\";s:3:\"zip\";s:13:\"clubflyer.zip\";s:3:\"uid\";s:32:\"dab73b9904d0e643a35b0475980998bd\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/club-flyer-landing-page-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This Club Fyler Template for Slider Revolution uses the brand new Exploding Layers Add-On to create a captivating effect. Tap into unlimited creative potential. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:187:\"[{\"path\":\"revslider-explodinglayers-addon\\/revslider-explodinglayers-addon.php\",\"name\":\"Exploding Layers AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:235;a:22:{s:2:\"id\";s:3:\"244\";s:5:\"title\";s:16:\"Paintbrush AddOn\";s:5:\"alias\";s:15:\"paintbrushaddon\";s:3:\"zip\";s:19:\"paintbrushaddon.zip\";s:3:\"uid\";s:32:\"c85c48a6742b4bf72a2590cc1b50f6a0\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/paintbrush-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">The Paintbrush Add-On for WordPress allows you to add cool mouse interaction effects to your Slider Revolution content. Examples: Blur Reveal, Color Reveal, Scratch Me Free.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-paintbrush-addon\\/revslider-paintbrush-addon.php\",\"name\":\"Paintbrush AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:236;a:25:{s:2:\"id\";s:3:\"245\";s:5:\"title\";s:18:\"Parallax One-Pager\";s:5:\"alias\";s:26:\"parallax-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"parallax-one-pager-package\";s:3:\"img\";s:39:\"packages/parallax-one-pager-package.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:237;a:25:{s:2:\"id\";s:3:\"246\";s:5:\"title\";s:15:\"Parallax Header\";s:5:\"alias\";s:15:\"parallax_header\";s:3:\"zip\";s:25:\"packs/parallax_header.zip\";s:3:\"uid\";s:32:\"32bf4a0f5136853bd6bd366275a7a60b\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:238;a:25:{s:2:\"id\";s:3:\"247\";s:5:\"title\";s:16:\"Parallax Content\";s:5:\"alias\";s:16:\"parallax_content\";s:3:\"zip\";s:26:\"packs/parallax_content.zip\";s:3:\"uid\";s:32:\"a25c5fb8f74757476ab4dc038e56f90d\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:239;a:25:{s:2:\"id\";s:3:\"248\";s:5:\"title\";s:15:\"Parallax Footer\";s:5:\"alias\";s:15:\"parallax_footer\";s:3:\"zip\";s:25:\"packs/parallax_footer.zip\";s:3:\"uid\";s:32:\"665dff9ea6eaf162a2a1f160f51a9ddb\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:240;a:25:{s:2:\"id\";s:3:\"249\";s:5:\"title\";s:18:\"Le Chef Restaurant\";s:5:\"alias\";s:18:\"le-chef-restaurant\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"le-chef-restaurant-package\";s:3:\"img\";s:39:\"packages/le-chef-restaurant-package.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:241;a:25:{s:2:\"id\";s:3:\"250\";s:5:\"title\";s:12:\"Le Chef Menu\";s:5:\"alias\";s:12:\"le-chef-menu\";s:3:\"zip\";s:22:\"packs/le-chef-menu.zip\";s:3:\"uid\";s:32:\"2f2a6a333431fefe4a7b3b6a982b2ff5\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:242;a:25:{s:2:\"id\";s:3:\"251\";s:5:\"title\";s:14:\"Le Chef Header\";s:5:\"alias\";s:14:\"le-chef-header\";s:3:\"zip\";s:24:\"packs/le-chef-header.zip\";s:3:\"uid\";s:32:\"06450ca3be5a4a8959f3752ab974e574\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:243;a:25:{s:2:\"id\";s:3:\"252\";s:5:\"title\";s:18:\"Le Chef Philosophy\";s:5:\"alias\";s:18:\"le-chef-philosophy\";s:3:\"zip\";s:28:\"packs/le-chef-philosophy.zip\";s:3:\"uid\";s:32:\"a532fd029addeb18106e751409b8e20a\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:244;a:25:{s:2:\"id\";s:3:\"253\";s:5:\"title\";s:12:\"Le Chef Food\";s:5:\"alias\";s:12:\"le-chef-food\";s:3:\"zip\";s:22:\"packs/le-chef-food.zip\";s:3:\"uid\";s:32:\"cd4b6a2cb5de2dd20a0e8ba0c35451df\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:245;a:25:{s:2:\"id\";s:3:\"254\";s:5:\"title\";s:16:\"Le Chef La Carte\";s:5:\"alias\";s:16:\"le-chef-la-carte\";s:3:\"zip\";s:26:\"packs/le-chef-la-carte.zip\";s:3:\"uid\";s:32:\"6f312749679c3ba52c41189a6b8bf729\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span cla